/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.layout;

import com.jrockit.mc.ui.layout.SimpleLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ReflowExpansionListener
extends ExpansionAdapter {
    private final IManagedForm m_form;
    private int m_oldMax = Integer.MAX_VALUE;

    public ReflowExpansionListener(IManagedForm form) {
        this.m_form = form;
    }

    public static SimpleLayoutData createCollapsed(ExpandableComposite ex) {
        SimpleLayoutData sd = new SimpleLayoutData();
        ReflowExpansionListener.setCollapsed(ex, sd);
        return sd;
    }

    private static void setCollapsed(ExpandableComposite ex, SimpleLayoutData sd) {
        Point p = ex.computeSize(ex.getClientArea().width, -1);
        sd.setMaxSize(p.y);
    }

    public void expansionStateChanged(ExpansionEvent e) {
        ExpandableComposite ex = (ExpandableComposite)e.getSource();
        Object data = ex.getLayoutData();
        if (data instanceof SimpleLayoutData) {
            SimpleLayoutData md = (SimpleLayoutData)data;
            if (!ex.isExpanded()) {
                this.m_oldMax = md.getMaximumSize();
                ReflowExpansionListener.setCollapsed(ex, md);
            } else {
                md.setMaxSize(this.m_oldMax);
            }
        }
        if (this.m_form != null) {
            this.m_form.reflow(true);
        }
    }
}

