/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.ui.misc.IGraphical;
import com.jrockit.mc.ui.misc.WarningDescriptorHelper;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AbstractWarningAction
implements IUserAction,
IGraphical {
    private WarningDescriptorHelper warningDescriptorHelper = new WarningDescriptorHelper();
    private String baseName;
    private String baseDescription;
    private ImageDescriptor baseImageDescriptor;

    public AbstractWarningAction() {
    }

    public AbstractWarningAction(String baseName, String description, ImageDescriptor imageDescriptor) {
        this.baseName = baseName;
        this.baseDescription = description;
        this.baseImageDescriptor = imageDescriptor;
    }

    public String getName() {
        return this.warningDescriptorHelper.getName(this.getBaseName());
    }

    public String getDescription() {
        return this.warningDescriptorHelper.getDescription(this.getBaseDescription());
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.warningDescriptorHelper.getImageDescriptor(this.getBaseImageDescriptor());
    }

    protected String getBaseName() {
        return this.baseName;
    }

    protected String getBaseDescription() {
        return this.baseDescription;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return this.baseImageDescriptor;
    }

    protected void setWarning(String message) {
        this.warningDescriptorHelper.setWarning(message);
    }

    protected void resetWarning() {
        this.warningDescriptorHelper.resetWarning();
    }

    public void execute() throws Exception {
        try {
            this.doExecute();
            this.warningDescriptorHelper.resetWarning();
        }
        catch (Exception e) {
            this.warningDescriptorHelper.setWarning(e.getLocalizedMessage());
            throw e;
        }
    }

    protected abstract void doExecute() throws Exception;
}

