/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.IColorProvider;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ColorProvider
implements IColorProvider,
IBaseLabelProvider {
    protected final int m_size;
    protected final Map<Object, Image> m_images = new HashMap<Object, Image>();
    protected final Map<Object, Color> m_colors = new HashMap<Object, Color>();
    protected final Display m_display;
    protected final int m_outlineWidth;
    protected Map<Object, Image> m_oldImages;
    protected Map<Object, Color> m_oldColors;

    public ColorProvider(Display display, int size) {
        this.m_size = size;
        this.m_outlineWidth = 2;
        this.m_display = display;
    }

    public Image createImage(Color color, Color outline) {
        if (this.m_display.isDisposed()) {
            return null;
        }
        Image image = new Image((Device)this.m_display, this.m_size, this.m_size);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(image.getBounds());
        Color border = new Color((Device)this.m_display, 0, 0, 0);
        gc.setForeground(border);
        gc.drawRectangle(0, 0, this.m_size - 1, this.m_size - 1);
        border.dispose();
        if (outline != null) {
            int n = 0;
            while (n < this.m_outlineWidth) {
                int width = this.m_size - 1 - n - (1 + n);
                if (width > 2) {
                    gc.setForeground(outline);
                    gc.drawRectangle(1 + n, 1 + n, width, width);
                }
                ++n;
            }
        }
        gc.dispose();
        return image;
    }

    @Override
    public Color getColor(Object object) {
        return this.m_colors.get(object);
    }

    public void registerOutlineColor(Object object, int outlineRed, int outLineGreen, int outLineBlue, int red, int green, int blue) {
        if (!this.m_images.containsValue(object)) {
            Color color = new Color((Device)this.m_display, red, green, blue);
            Color outline = new Color((Device)this.m_display, outlineRed, outLineGreen, outLineBlue);
            this.m_images.put(object, this.createImage(color, outline));
            outline.dispose();
            color.dispose();
        }
    }

    public void registerColor(Object object, int red, int green, int blue) {
        Color color = this.m_colors.get(object);
        if (color == null) {
            color = new Color((Device)this.m_display, red, green, blue);
            this.m_colors.put(object, color);
            this.m_images.put(object, this.createImage(color, null));
        }
    }

    public void registerColor(Object object, MCColor color) {
        this.registerColor(object, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void unRegisterColor(Object object) {
        if (object != null) {
            Image image;
            Color color = this.m_colors.remove(object);
            if (color != null) {
                color.dispose();
            }
            if ((image = this.m_images.remove(object)) != null) {
                image.dispose();
            }
        }
    }

    public Image getImage(Object element) {
        this.flushOldGDIResources();
        return this.m_images.get(element);
    }

    private void flushOldGDIResources() {
        if (this.m_oldImages != null) {
            this.clearImages(this.m_oldImages.values());
            this.m_oldImages = null;
        }
        if (this.m_oldColors != null) {
            this.clearColors(this.m_oldColors.values());
            this.m_oldColors = null;
        }
    }

    public void clear() {
        this.clearImages(this.m_images.values());
        this.clearColors(this.m_colors.values());
    }

    private void clearColors(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
        colors.clear();
    }

    private void clearImages(Collection<Image> images) {
        for (Image image : images) {
            image.dispose();
        }
        images.clear();
    }

    public void dispose() {
        this.flushOldGDIResources();
        this.clear();
    }

    public void invalidate() {
        if (this.m_oldImages != null) {
            this.clearImages(this.m_oldImages.values());
            this.m_oldImages = new HashMap<Object, Image>(this.m_images);
        }
        if (this.m_oldColors != null) {
            this.clearColors(this.m_oldColors.values());
            this.m_oldColors = new HashMap<Object, Color>(this.m_colors);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getText(Object element) {
        return null;
    }
}

