/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelector
extends Composite {
    public static final String PROPERTY_NO_FILE_SPECIFIED = "no.file.specified";
    public static final String PROPERTY_FILE_DOES_NOT_EXIST = "file.does.not.exist";
    public static final String PROPERTY_DIR_DOES_NOT_EXIST = "directory.does.not.exist";
    public static final String PROPERTY_VALID_FILE_NAME_ENTERED = "valid.file.name.specified";
    public static final String LAST_FILE_NAME = "last.file.name";
    private final IDialogSettings m_settings;
    private final ListenerList m_listeners = new ListenerList();
    private final boolean m_mustExist;
    private final String m_labelText;
    private Text m_filename;
    private final String m_fileExtension;
    private File m_file;
    private final int style;

    public FileSelector(Composite parent, IDialogSettings settings, String label, boolean mustExistToBeValid, int style, String defaultFileName, String fileExt) {
        super(parent, style);
        this.style = style;
        this.m_fileExtension = fileExt == null ? null : (fileExt.startsWith(".") ? fileExt : String.valueOf('.') + fileExt);
        this.m_labelText = label;
        this.m_settings = settings;
        this.m_mustExist = mustExistToBeValid;
        this.createFileSelection(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FileSelector.this.m_listeners.clear();
            }
        });
        String storedFileName = this.getStoredFileName();
        if (defaultFileName == null) {
            this.m_filename.setText(storedFileName == null ? "" : storedFileName);
        } else {
            File pf = storedFileName == null ? new File(".") : new File(storedFileName).getParentFile();
            int i = 0;
            File suggestion = new File(pf, String.valueOf(defaultFileName) + i + this.m_fileExtension);
            while (suggestion.exists()) {
                suggestion = new File(pf, String.valueOf(defaultFileName) + ++i + this.m_fileExtension);
            }
            this.m_filename.setText(suggestion.getAbsolutePath());
        }
    }

    private void updateFileName() {
        this.m_file = null;
        String fileText = this.m_filename.getText();
        if (fileText == null || fileText.trim().length() == 0) {
            this.fireEvent(PROPERTY_NO_FILE_SPECIFIED, Messages.FileSelectorComposite_PLEASE_SPECIFY_FILE);
        } else {
            File file = new File(fileText);
            if (!file.isAbsolute()) {
                this.fireEvent(PROPERTY_DIR_DOES_NOT_EXIST, Messages.FileSelectorComposite_DIR_DOES_NOT_EXIST);
            } else if (file.isDirectory()) {
                this.fireEvent(PROPERTY_NO_FILE_SPECIFIED, Messages.FileSelectorComposite_PLEASE_SPECIFY_FILE);
            } else if (fileText.endsWith("/") || fileText.endsWith("\\") || !file.getParentFile().isDirectory()) {
                this.fireEvent(PROPERTY_DIR_DOES_NOT_EXIST, Messages.FileSelectorComposite_DIR_DOES_NOT_EXIST);
            } else {
                if (this.m_fileExtension != null && !fileText.toLowerCase().endsWith(this.m_fileExtension.toLowerCase())) {
                    file = new File(String.valueOf(fileText) + this.m_fileExtension);
                }
                if (this.m_mustExist && !file.exists()) {
                    String msg = MessageFormat.format(Messages.FILE_DOES_NOT_EXIST, fileText);
                    this.fireEvent(PROPERTY_FILE_DOES_NOT_EXIST, msg);
                } else {
                    this.m_file = file;
                    this.fireEvent(PROPERTY_VALID_FILE_NAME_ENTERED, null);
                }
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.m_listeners.add((Object)listener);
        this.updateFileName();
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.m_listeners.remove((Object)listener);
    }

    private void fireEvent(String property, String message) {
        Object[] objects;
        Object[] objectArray = objects = this.m_listeners.getListeners();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IPropertyChangeListener p = (IPropertyChangeListener)object;
            p.propertyChange(new PropertyChangeEvent((Object)this, property, null, (Object)message));
            ++n2;
        }
    }

    private String getStoredFileName() {
        return this.m_settings != null ? this.m_settings.get(LAST_FILE_NAME) : null;
    }

    protected Composite createFileSelection(Composite container) {
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gridDataLabel = new GridData(4, 0x1000000, false, false);
        Label l = this.createLabel(container, this.m_labelText);
        l.setLayoutData((Object)gridDataLabel);
        GridData gridDataFileName = new GridData(4, 0x1000000, true, false);
        this.m_filename = this.createTextInput(container);
        this.m_filename.setLayoutData((Object)gridDataFileName);
        GridData gridDataFileSelectionButton = new GridData(4, 0x1000000, false, false);
        Button fileSectionButton = this.createBrowseButton(container);
        fileSectionButton.setLayoutData((Object)gridDataFileSelectionButton);
        return container;
    }

    private Text createTextInput(Composite container) {
        Text text = new Text(container, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSelector.this.updateFileName();
            }
        });
        return text;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        return label;
    }

    private Button createBrowseButton(Composite container) {
        Button fileSectionButton = new Button(container, 0);
        fileSectionButton.setText(Messages.FileSelectorComposite_FILE_SELECTOR_BROWSE_BUTTON_TEXT);
        fileSectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileSelector.this.m_filename.isDisposed()) {
                    FileSelector.this.openSelectFileDialog();
                }
            }
        });
        return fileSectionButton;
    }

    private void openSelectFileDialog() {
        String filename;
        File f;
        FileDialog dialog = new FileDialog(this.getShell(), this.style);
        if (this.m_fileExtension != null) {
            dialog.setFilterExtensions(new String[]{"*" + this.m_fileExtension});
        }
        if (this.m_filename.getText() != null && this.m_filename.getText().trim().length() > 0 && (f = new File(this.m_filename.getText())).isAbsolute()) {
            if (f.isDirectory()) {
                dialog.setFilterPath(f.getAbsolutePath());
            } else if (f.getParentFile().isDirectory()) {
                dialog.setFilterPath(f.getParentFile().getAbsolutePath());
            }
        }
        if ((filename = dialog.open()) != null) {
            this.m_filename.setText(filename);
            this.m_filename.setSelection(this.m_filename.getText().length());
            this.updateFileName();
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public void storeFilename() {
        if (this.m_settings != null && this.m_file != null) {
            this.m_settings.put(LAST_FILE_NAME, this.m_file.getAbsolutePath());
        }
    }
}

