/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.ui.UIPlugin;
import java.awt.GraphicsEnvironment;
import java.util.logging.Level;
import javax.swing.UIManager;

public class SwingSupport {
    public static final boolean IS_WINDOWS;
    public static final boolean IS_PRE_JDK15;
    public static final boolean IS_POST_JDK15;
    private static boolean INITIALIZED;
    private static Object INIT_LOCK;

    static {
        INIT_LOCK = new Object();
        IS_WINDOWS = OS.getType() == OS.Type.WINDOWS;
        String javaVersion = System.getProperty("java.version");
        IS_PRE_JDK15 = "1.5".compareTo(javaVersion) > 0;
        IS_POST_JDK15 = "1.6".compareTo(javaVersion) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLookAndFeel() {
        Object object = INIT_LOCK;
        synchronized (object) {
            UIPlugin.getDefault().getLogger().log(Level.INFO, "Initializing Swing L&F!");
            if (!INITIALIZED) {
                if (SwingSupport.isHeadless()) {
                    UIPlugin.getDefault().getLogger().log(Level.INFO, "Skipped initializing L&F since we're running headless!");
                    INITIALIZED = true;
                    return;
                }
                String laf = System.getProperty("swing.systemlaf");
                if (laf != null) {
                    UIPlugin.getDefault().getLogger().log(Level.INFO, "Overriding Swing L&F with " + laf);
                } else {
                    laf = UIManager.getSystemLookAndFeelClassName();
                    UIPlugin.getDefault().getLogger().log(Level.INFO, "System Swing L&F is " + laf);
                    if (!IS_WINDOWS && laf.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
                        UIPlugin.getDefault().getLogger().log(Level.WARNING, "Found GTK Swing L&F, which is currently not supported!");
                        laf = UIManager.getCrossPlatformLookAndFeelClassName();
                        UIPlugin.getDefault().getLogger().log(Level.WARNING, "Cross platform Swing L&F is " + laf);
                        UIManager.put("swing.boldMetal", Boolean.FALSE);
                    }
                }
                try {
                    UIPlugin.getDefault().getLogger().log(Level.INFO, "Setting L&F to " + laf);
                    UIManager.setLookAndFeel(laf);
                }
                catch (Exception e) {
                    UIPlugin.getDefault().getLogger().log(Level.WARNING, "Error setting Swing L&F to " + laf, e);
                }
                INITIALIZED = true;
            }
        }
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }
}

