/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.ImageToolkit;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class TwoStateImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor base;
    private boolean enabled;
    private ImageData enabledOverlay;
    private ImageData disabledOverlay;

    public TwoStateImageDescriptor(ImageDescriptor base, boolean enabled) {
        this.base = base;
        this.enabled = enabled;
    }

    public TwoStateImageDescriptor(ImageDescriptor base, boolean enabled, ImageData enabledOverlay, ImageData disabledOverlay) {
        this.base = base;
        this.enabledOverlay = enabledOverlay;
        this.disabledOverlay = disabledOverlay;
        this.enabled = enabled;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData id = this.base.getImageData();
        if (!this.enabled) {
            ImageToolkit.adjustAlphaLevel(id, 2);
        }
        this.drawImage(id, 0, 0);
        if (this.enabled && this.enabledOverlay != null) {
            this.drawImage(this.enabledOverlay, 0, 0);
        } else if (!this.enabled && this.disabledOverlay != null) {
            this.drawImage(this.disabledOverlay, 0, 0);
        }
    }

    protected Point getSize() {
        ImageData baseData = this.base.getImageData();
        return new Point(baseData.width, baseData.height);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TwoStateImageDescriptor)) {
            return false;
        }
        TwoStateImageDescriptor other = (TwoStateImageDescriptor)((Object)obj);
        return other.enabled == this.enabled && other.base.equals(this.base);
    }
}

