/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class VerticalSectionLayout
extends Layout {
    private final int marginWidth;
    private final int marginHeight;
    private final int verticalSpacing;

    public VerticalSectionLayout() {
        this(6, 6, 6);
    }

    private VerticalSectionLayout(int marginWidth, int marginHeight, int verticalSpacing) {
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
        this.verticalSpacing = verticalSpacing;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (composite.getChildren().length == 0) {
            return new Point(0, 0);
        }
        int width = 2 * this.marginWidth;
        int height = 2 * this.marginHeight;
        int expandedComponents = 0;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point size = child.computeSize(-1, -1, flushCache);
            height += size.y;
            if (this.isChildExpanded(child)) {
                ++expandedComponents;
            }
            width = Math.max(width, size.x);
            ++n2;
        }
        if (expandedComponents > 0) {
            height += (expandedComponents - 1) * this.verticalSpacing;
        }
        return new Point(width, height);
    }

    private boolean isChildExpanded(Control child) {
        return child instanceof ExpandableComposite && ((ExpandableComposite)child).isExpanded();
    }

    private int[] calculateHeights(Composite composite, int boundWidth, int boundHeight, boolean flushCache) {
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return new int[0];
        }
        int expanded = 0;
        int unexpandedHeight = 0;
        int[] heights = new int[children.length];
        int i = 0;
        while (i < children.length) {
            if (this.isChildExpanded(children[i])) {
                ++expanded;
            } else {
                heights[i] = children[i].computeSize((int)boundWidth, (int)-1, (boolean)flushCache).y;
                unexpandedHeight += heights[i];
            }
            ++i;
        }
        if (expanded == 0) {
            return heights;
        }
        int expandedHeight = 0;
        int totalVerticalSpacing = this.verticalSpacing * (expanded - 1);
        int height = boundHeight - totalVerticalSpacing - 2 * this.marginHeight;
        int heightToSuggestToExpanded = (int)((double)(height - unexpandedHeight) / ((double)expanded + 0.5));
        int i2 = 0;
        while (i2 < children.length) {
            if (this.isChildExpanded(children[i2])) {
                heights[i2] = children[i2].computeSize((int)boundWidth, (int)heightToSuggestToExpanded).y;
                expandedHeight += heights[i2];
            }
            ++i2;
        }
        int remaining = height - (unexpandedHeight + expandedHeight);
        if (remaining > 0) {
            int part = (int)((float)remaining / (float)expanded);
            int i3 = 0;
            while (i3 < children.length) {
                if (this.isChildExpanded(children[i3])) {
                    if (expanded == 1) {
                        int n = i3;
                        heights[n] = heights[n] + remaining;
                        break;
                    }
                    int n = i3;
                    heights[n] = heights[n] + part;
                    remaining -= part;
                    --expanded;
                }
                ++i3;
            }
        }
        return heights;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle outerBounds = composite.getBounds();
        int[] heights = this.calculateHeights(composite, outerBounds.width, outerBounds.height, flushCache);
        Control[] children = composite.getChildren();
        int y = this.marginHeight;
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(outerBounds.x + this.marginWidth, y, outerBounds.width - 2 * this.marginWidth, heights[i]);
            y += heights[i];
            if (this.isChildExpanded(children[i])) {
                y += this.verticalSpacing;
            }
            ++i;
        }
    }
}

