/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.Messages;
import com.jrockit.mc.ui.misc.TwoStateImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;

public class WarningDescriptorHelper {
    private String warningMessage = null;
    private String warningMessageLong = null;
    private ImageDescriptor warningOverlay = UIPlugin.getDefault().getMCImageDescriptor("overlay_warning.gif");

    public String getName(String baseName) {
        return String.valueOf(baseName) + (this.warningMessage != null ? " (" + this.warningMessage + ")" : "");
    }

    public String getDescription(String baseDescription) {
        return String.valueOf(baseDescription) + (this.warningMessage != null ? " (" + this.warningMessageLong + ")" : "");
    }

    public void setWarning(String message) {
        this.warningMessage = Messages.AbstractWarningItem_WARNING;
        this.warningMessageLong = String.valueOf(Messages.AbstractWarningItem_WARNING) + ": " + message;
    }

    public void setSpecificWarning(String message) {
        this.warningMessage = message;
        this.warningMessageLong = message;
    }

    public void resetWarning() {
        this.warningMessage = null;
        this.warningMessageLong = null;
    }

    public ImageDescriptor getImageDescriptor(ImageDescriptor baseImageDescriptor) {
        return new TwoStateImageDescriptor(baseImageDescriptor, this.warningMessage == null, null, this.warningOverlay.getImageData());
    }
}

