/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.FixedDisplayUnit;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.ui.model.fields.BooleanField;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.ClassField;
import com.jrockit.mc.ui.model.fields.CountField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FixedUnitField;
import com.jrockit.mc.ui.model.fields.HexField;
import com.jrockit.mc.ui.model.fields.MethodField;
import com.jrockit.mc.ui.model.fields.NanosTimeSpanField;
import com.jrockit.mc.ui.model.fields.NanosTimeStampField;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.PercentageField;
import com.jrockit.mc.ui.model.fields.PortField;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.model.fields.ThreadField;

public final class FieldFactory {
    private static Field timeBase(UnitDescriptor descriptor, NumberField field) {
        field.setTimeBased(descriptor.getDerivative());
        return field;
    }

    static <T extends Field> T makeIdentifiable(T field, String identifier) {
        field.IDENTIFIER = identifier;
        return field;
    }

    public static Field createFromDisplayUnitWithIndexIdentifier(UnitDescriptor unitDescriptor, String identifier, int index) {
        return FieldFactory.createFromDisplayUnit(unitDescriptor, String.valueOf(identifier) + "." + index, index);
    }

    public static Field createFromDisplayUnit(UnitDescriptor unitDescriptor, String identifier, int index) {
        DisplayUnit displayUnit = unitDescriptor.getDisplayUnit();
        String di = displayUnit.getIdentifier();
        displayUnit.getContentType();
        ContentType ct = displayUnit.getContentType();
        if (ct.equals(UnitLookup.FLAG)) {
            return FieldFactory.makeIdentifiable(new BooleanField(index), identifier);
        }
        if (ct.equals(UnitLookup.CLASS)) {
            return FieldFactory.makeIdentifiable(new ClassField(index), identifier);
        }
        if (ct.equals(UnitLookup.METHOD)) {
            return FieldFactory.makeIdentifiable(new MethodField(index), identifier);
        }
        if (ct.equals(UnitLookup.THREAD)) {
            return FieldFactory.makeIdentifiable(new ThreadField(index), identifier);
        }
        if (ct.equals(UnitLookup.PLAIN_TEXT)) {
            return FieldFactory.makeIdentifiable(new StringField(index), identifier);
        }
        if (displayUnit instanceof FixedDisplayUnit) {
            return FieldFactory.timeBase(unitDescriptor, FieldFactory.createFixedNumberField((FixedDisplayUnit)displayUnit, identifier, index));
        }
        if (ct.equals(UnitLookup.MEMORY)) {
            return FieldFactory.timeBase(unitDescriptor, FieldFactory.makeIdentifiable(new ByteField(index), identifier));
        }
        if (ct.equals(UnitLookup.PERCENTAGE)) {
            if ("accuracy0digits".equals(di)) {
                return FieldFactory.makeIdentifiable(new PercentageField(index, 0), identifier);
            }
            if ("accuracy1digit".equals(di)) {
                return FieldFactory.makeIdentifiable(new PercentageField(index, 1), identifier);
            }
            if ("accuracy3digits".equals(di)) {
                return FieldFactory.makeIdentifiable(new PercentageField(index, 3), identifier);
            }
            return new PercentageField(index, 2);
        }
        if (ct.equals(UnitLookup.TIMESTAMP)) {
            return FieldFactory.makeIdentifiable(new NanosTimeStampField(index), identifier);
        }
        if (ct.equals(UnitLookup.TIMESPAN)) {
            return FieldFactory.makeIdentifiable(new NanosTimeSpanField(index), identifier);
        }
        if (ct.equals(UnitLookup.ADDRESS)) {
            return FieldFactory.makeIdentifiable(new HexField(index), identifier);
        }
        if (ct.equals(UnitLookup.COUNT) || ct.equals(UnitLookup.INDEX)) {
            return FieldFactory.makeIdentifiable(FieldFactory.timeBase(unitDescriptor, new CountField(index)), identifier);
        }
        if (ct.equals(UnitLookup.PORT)) {
            return FieldFactory.makeIdentifiable(FieldFactory.timeBase(unitDescriptor, new PortField(index)), identifier);
        }
        if (ct.equals(UnitLookup.NUMBER)) {
            return FieldFactory.makeIdentifiable(FieldFactory.timeBase(unitDescriptor, new NumberField(index)), identifier);
        }
        return FieldFactory.makeIdentifiable(new Field(index), identifier);
    }

    private static NumberField createFixedNumberField(FixedDisplayUnit displayUnit, String identifier, int index) {
        FixedUnitField field = FieldFactory.makeIdentifiable(new FixedUnitField(index), identifier);
        field.setConversionFactor(displayUnit.getUnitMultiplier());
        field.setUnit(displayUnit.getUnitName());
        return field;
    }
}

