/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.common.unit.BinaryPrefix;
import com.jrockit.mc.ui.model.fields.ByteUnit;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.NumberFormat;
import java.text.ParseException;

public class FrequencyByteField
extends NumberField {
    private static final NumberFormat FORMATTER = NumberFormat.getInstance();
    private static final String[] SPACED_UNITS;

    static {
        FORMATTER.setMinimumFractionDigits(2);
        FORMATTER.setMaximumFractionDigits(2);
        BinaryPrefix[] prefixes = BinaryPrefix.values();
        SPACED_UNITS = new String[prefixes.length];
        FrequencyByteField.SPACED_UNITS[0] = " bytes/s";
        int i = 1;
        while (i < prefixes.length) {
            FrequencyByteField.SPACED_UNITS[i] = String.valueOf(' ') + prefixes[i].prefixSI + "B/s";
            ++i;
        }
    }

    public static String shortFormat(double value) {
        BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((double)value);
        return String.valueOf(FORMATTER.format(prefix.convertTo(value))) + SPACED_UNITS[prefix.log1024()];
    }

    public FrequencyByteField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        Number number;
        if (object instanceof Number && FrequencyByteField.isValid(number = (Number)object)) {
            double value = number.doubleValue();
            return FrequencyByteField.shortFormat(value);
        }
        return super.formatObject(object);
    }

    @Override
    public String getUnit() {
        return "bytes/s";
    }

    @Override
    public String getTooltip(Object object) {
        if (object instanceof Number && FrequencyByteField.isValid((Number)object)) {
            return String.valueOf(FORMATTER.format(((Number)object).doubleValue())) + ' ' + this.getUnit();
        }
        return null;
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Double number = FrequencyByteField.parseNumber(tokenizer);
        if (number instanceof Number) {
            double value = ((Number)number).doubleValue();
            if (tokenizer.hasNext()) {
                ByteUnit byteUnit;
                String text = tokenizer.peek().text;
                if (text.endsWith("/s")) {
                    text = text.substring(0, text.length() - 2);
                }
                if ((byteUnit = ByteUnit.valueOfString(text)) != null) {
                    value *= (double)byteUnit.getFactor();
                    tokenizer.next();
                }
            }
            return value;
        }
        return null;
    }
}

