/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.service.prefs.BackingStoreException;

public final class EclipsePreferencesWrapper
implements IPersistentPreferenceStore {
    private final IEclipsePreferences defaultPreferences;
    private final IEclipsePreferences preferences;
    private Map<IPropertyChangeListener, PreferenceChangeListenerWrapper> listeners = new HashMap<IPropertyChangeListener, PreferenceChangeListenerWrapper>();

    public EclipsePreferencesWrapper(IEclipsePreferences preferences) {
        this(preferences, preferences);
    }

    public EclipsePreferencesWrapper(IEclipsePreferences defaultPreferences, IEclipsePreferences preferences) {
        this.defaultPreferences = defaultPreferences;
        this.preferences = preferences;
    }

    public void setValue(String name, boolean value) {
        this.preferences.putBoolean(name, value);
    }

    public void setValue(String name, String value) {
        this.preferences.put(name, value);
    }

    public void setValue(String name, long value) {
        this.preferences.putLong(name, value);
    }

    public void setValue(String name, int value) {
        this.preferences.putInt(name, value);
    }

    public void setValue(String name, float value) {
        this.preferences.putFloat(name, value);
    }

    public void setValue(String name, double value) {
        this.preferences.putDouble(name, value);
    }

    public void setToDefault(String name) {
        if (this.preferences != this.defaultPreferences) {
            this.preferences.remove(name);
        }
    }

    public void setDefault(String name, boolean value) {
        this.defaultPreferences.putBoolean(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.defaultPreferences.put(name, defaultObject);
    }

    public void setDefault(String name, long value) {
        this.defaultPreferences.putLong(name, value);
    }

    public void setDefault(String name, int value) {
        this.defaultPreferences.putInt(name, value);
    }

    public void setDefault(String name, float value) {
        this.defaultPreferences.putFloat(name, value);
    }

    public void setDefault(String name, double value) {
        this.defaultPreferences.putDouble(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        PreferenceChangeListenerWrapper listenerWrapper;
        Map<IPropertyChangeListener, PreferenceChangeListenerWrapper> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.containsKey(listener)) {
                return;
            }
            listenerWrapper = this.listeners.get(listener);
            this.listeners.remove(listener);
        }
        this.defaultPreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listenerWrapper);
        this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listenerWrapper);
    }

    public void putValue(String name, String value) {
        throw new UnsupportedOperationException("Not implemented in wrapper!");
    }

    public boolean needsSaving() {
        return true;
    }

    public boolean isDefault(String name) {
        if (this.contains(name)) {
            String value = this.getString(name);
            if (value == null) {
                return this.getDefaultString(name) == null;
            }
            return value.equals(this.getDefaultString(name));
        }
        return false;
    }

    public String getString(String name) {
        return this.preferences.get(name, this.getDefaultString(name));
    }

    public long getLong(String name) {
        return this.preferences.getLong(name, this.getDefaultLong(name));
    }

    public int getInt(String name) {
        return this.preferences.getInt(name, this.getDefaultInt(name));
    }

    public float getFloat(String name) {
        return this.preferences.getFloat(name, this.getDefaultFloat(name));
    }

    public double getDouble(String name) {
        return this.preferences.getDouble(name, this.getDefaultDouble(name));
    }

    public String getDefaultString(String name) {
        return this.defaultPreferences.get(name, "");
    }

    public long getDefaultLong(String name) {
        return this.defaultPreferences.getLong(name, 0L);
    }

    public int getDefaultInt(String name) {
        return this.defaultPreferences.getInt(name, 0);
    }

    public float getDefaultFloat(String name) {
        return this.defaultPreferences.getFloat(name, 0.0f);
    }

    public double getDefaultDouble(String name) {
        return this.defaultPreferences.getDouble(name, 0.0);
    }

    public boolean getDefaultBoolean(String name) {
        return this.defaultPreferences.getBoolean(name, false);
    }

    public boolean getBoolean(String name) {
        return this.preferences.getBoolean(name, this.getDefaultBoolean(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        IPropertyChangeListener[] listeners;
        Map<IPropertyChangeListener, PreferenceChangeListenerWrapper> map = this.listeners;
        synchronized (map) {
            listeners = this.listeners.keySet().toArray(new IPropertyChangeListener[this.listeners.size()]);
        }
        IPropertyChangeListener[] iPropertyChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            listener.propertyChange(event);
            ++n2;
        }
    }

    public boolean contains(String name) {
        return EclipsePreferencesWrapper.preferencesContain(this.preferences, name) || EclipsePreferencesWrapper.preferencesContain(this.defaultPreferences, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean preferencesContain(IEclipsePreferences preferences, String name) {
        try {
            String[] stringArray = preferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String key = stringArray[n2];
                if (key.equals(name)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        Map<IPropertyChangeListener, PreferenceChangeListenerWrapper> map = this.listeners;
        synchronized (map) {
            if (this.listeners.containsKey(listener)) {
                return;
            }
        }
        PreferenceChangeListenerWrapper listenerWrapper = new PreferenceChangeListenerWrapper(this, listener);
        Map<IPropertyChangeListener, PreferenceChangeListenerWrapper> map2 = this.listeners;
        synchronized (map2) {
            this.listeners.put(listener, listenerWrapper);
        }
        this.defaultPreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listenerWrapper);
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listenerWrapper);
    }

    public void save() throws IOException {
        try {
            this.defaultPreferences.flush();
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            IOException ioe = new IOException("Unable to store!");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static class PreferenceChangeListenerWrapper
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final EclipsePreferencesWrapper preferencesWrapper;
        private final IPropertyChangeListener propertyChangeListener;

        public PreferenceChangeListenerWrapper(EclipsePreferencesWrapper preferencesWrapper, IPropertyChangeListener propertyChangeListener) {
            this.preferencesWrapper = preferencesWrapper;
            this.propertyChangeListener = propertyChangeListener;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PropertyChangeEvent newEvent = new PropertyChangeEvent((Object)this.preferencesWrapper, event.getKey(), event.getOldValue(), event.getNewValue());
            this.propertyChangeListener.propertyChange(newEvent);
        }
    }
}

