/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FieldTableEditAction;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.handlers.FieldViewerContributionFactory;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.ViewerSectionPart;
import com.jrockit.mc.ui.site.HandlerActivator;
import com.jrockit.mc.ui.site.MenuFactoryActivator;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class FieldViewerSectionPart
extends ViewerSectionPart {
    private final IDialogSettings m_settings;
    private final Field[] m_fields;

    public FieldViewerSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, Field[] fieldPrototypes, IDialogSettings settings) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_settings = settings;
        this.m_fields = this.createFieldInstances(fieldPrototypes);
    }

    protected Field[] createFieldInstances(Field[] fieldPrototypes) {
        return FieldToolkit.instantiateFieldArray(fieldPrototypes);
    }

    protected abstract Composite createFieldViewerClient(IManagedForm var1, FormToolkit var2, Composite var3);

    protected IDialogSettings getSettings() {
        return this.m_settings;
    }

    protected Field[] getFields() {
        return this.m_fields;
    }

    @Override
    protected final Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        this.loadDialogSettings(this.getSettings());
        this.setupFieldMenu();
        return this.createFieldViewerClient(form, formToolkit, section);
    }

    protected void setupFieldMenu() {
        this.registerFieldFactoryContributions();
        if (this.hasTitle()) {
            FieldTableEditAction ftea = new FieldTableEditAction(this.getSettings());
            ftea.setFields(this.getFields());
            this.getMCToolBarManager().add((IAction)ftea);
        }
    }

    protected void registerFieldFactoryContributions() {
        FieldViewerContributionFactory fvcf = new FieldViewerContributionFactory(this.getFields(), this.getFormContainerSite(), this.getSectionIdentifier());
        Collection<Command> commands = fvcf.createCommands();
        Collection<IHandler> handlers = fvcf.createHandlers();
        if (commands.size() == handlers.size()) {
            Iterator<Command> itC = commands.iterator();
            Iterator<IHandler> itH = handlers.iterator();
            while (itH.hasNext() && itC.hasNext()) {
                Command command = itC.next();
                IHandler handler = itH.next();
                if (command == null || handler == null) continue;
                this.getSite().registerActivator(new HandlerActivator(command.getId(), handler));
            }
            this.getSite().registerActivator(new MenuFactoryActivator(fvcf));
        } else {
            UIPlugin.getDefault().getLogger().severe("The number of handlers dosen't match the number of commands. The context menu will not be complete for" + this.getSectionIdentifier());
        }
    }

    @Override
    protected void setupSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings == null) {
            tableSettings = settings.addNewSection(this.getSectionIdentifier());
        }
        FieldToolkit.fillDialogSettingsFromFields(this.getFields(), tableSettings);
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings != null) {
            FieldToolkit.fillFieldsFromDialogSettings(tableSettings, this.getFields());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.saveDialogSettings(this.getSettings());
        Field[] fields = this.getFields();
        if (fields != null) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.dispose();
                ++n2;
            }
        }
    }
}

