/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.security;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.security.Messages;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class MasterPasswordWizardPage
extends WizardPage
implements IPerformFinishable {
    static final String PAGE_NAME = Messages.MASTER_PASSWORD_WIZARD_PAGE;
    private Text passwordField;
    private Text passwordField2;
    private final boolean usePasswordVerification;
    private final boolean warnForDataClear;
    private static final int MIN_PASSWORD_LENGTH = 5;
    private String password;

    String getMasterPassword() {
        return this.password;
    }

    public MasterPasswordWizardPage(boolean usePasswordVerification, boolean warnForDataClear) {
        super(PAGE_NAME);
        this.usePasswordVerification = usePasswordVerification;
        this.warnForDataClear = warnForDataClear;
        this.setImageDescriptor(UIPlugin.getDefault().getImageRegistry().getDescriptor("class_obj.gif"));
        if (usePasswordVerification) {
            this.setTitle(Messages.MasterPasswordWizardPage_SET_MASTER_PASSWORD_TITLE);
        } else {
            this.setTitle(Messages.MasterPasswordWizardPage_VERIFY_MASTER_PASSWORD_TITLE);
        }
    }

    public void createControl(Composite parent) {
        this.initializeMessages();
        InputVerifier listener = new InputVerifier();
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 16384);
        container.setLayout((Layout)new GridLayout());
        Composite passwordContainer = new Composite(container, 16384);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        passwordContainer.setLayoutData((Object)gd);
        passwordContainer.setLayout((Layout)new GridLayout(2, false));
        String labelText = this.usePasswordVerification ? Messages.MasterPasswordWizardPage_CAPTION_NEW_PASSWORD : Messages.MasterPasswordWizardPage_CAPTION_ENTER_PASSWORD;
        Label firstPasswordLabel = new Label(passwordContainer, 16384);
        firstPasswordLabel.setText(labelText);
        firstPasswordLabel.setToolTipText(Messages.MasterPasswordWizardPage_TOOLTIP_ENTER_PASSWORD);
        this.passwordField = new Text(passwordContainer, 0x400804);
        GridData data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        this.passwordField.addModifyListener((ModifyListener)listener);
        if (this.usePasswordVerification) {
            Label secondPasswordLabel = new Label(passwordContainer, 16384);
            secondPasswordLabel.setText(Messages.MasterPasswordWizardPage_CAPTION_CONFIRM_PASSWORD);
            secondPasswordLabel.setToolTipText(Messages.MasterPasswordWizardPage_TOOLTIP_CONFIRM_PASSWORD);
            data = new GridData(768);
            secondPasswordLabel.setLayoutData((Object)data);
            this.passwordField2 = new Text(passwordContainer, 0x400804);
            GridData data2 = new GridData(768);
            this.passwordField2.setLayoutData((Object)data2);
            this.passwordField2.addModifyListener((ModifyListener)listener);
        }
        this.setControl((Control)passwordContainer);
        this.setPageComplete(false);
        if (this.warnForDataClear) {
            Label dataClearWarnLabel = new Label(container, 16385);
            dataClearWarnLabel.setText(Messages.MasterPasswordWizardPage_WARN_DATA_CLEAR_TEXT);
            dataClearWarnLabel.setToolTipText(Messages.MasterPasswordWizardPage_WARN_DATA_CLEAR_TEXT);
            dataClearWarnLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        }
        container.layout();
    }

    private void initializeMessages() {
        this.setErrorMessage(null);
        if (this.usePasswordVerification) {
            this.setMessage(Messages.MasterPasswordWizardPage_SET_MASTER_PASSWORD_DESCRIPTION_TEXT);
        } else {
            this.setMessage(Messages.MasterPasswordWizardPage_VERIFY_MASTER_PASSWORD_DESCRIPTION_TEXT);
        }
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        final Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        return messageComposite;
    }

    private void checkPageComplete() {
        if (this.passwordField.getText().length() <= 0) {
            this.setErrorMessage(Messages.MasterPasswordWizardPage_ERROR_PASSWORD_EMPTY_TEXT);
            return;
        }
        if (this.passwordField.getText().length() < 5) {
            this.setErrorMessage(NLS.bind((String)Messages.MasterPasswordWizardPage_ERROR_MESSAGE_PASSWORD_SHORTER_THAN_X_CAHARCTERS_TEXT, (Object)5));
            return;
        }
        if (this.usePasswordVerification && !this.passwordField.getText().equals(this.passwordField2.getText())) {
            this.setErrorMessage(Messages.MasterPasswordWizardPage_ERROR_MESSAGE_PASSWORDS_DO_NOT_MATCH_TEXT);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    @Override
    public boolean performFinish() {
        this.password = this.passwordField.getText();
        return true;
    }

    private class InputVerifier
    implements ModifyListener {
        private InputVerifier() {
        }

        public void modifyText(ModifyEvent e) {
            MasterPasswordWizardPage.this.checkPageComplete();
        }
    }
}

