/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.site;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.site.AbstractSiteActivator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.handlers.IHandlerActivation;

public class HandlerActivator
extends AbstractSiteActivator {
    private final String m_commandid;
    private final IHandler m_handler;
    private IHandlerActivation m_activationHandler;

    public HandlerActivator(String commandId, IHandler handler) {
        this.m_commandid = commandId;
        this.m_handler = handler;
    }

    @Override
    public void activate() {
        Command com = this.getSite().getCommandService().getCommand(this.m_commandid);
        this.m_activationHandler = this.getSite().getHandlerService().activateHandler(this.m_commandid, this.m_handler);
        if (com != null) {
            com.setHandler(this.m_handler);
            this.getSite().getCommandService().refreshElements(this.m_commandid, null);
        } else {
            UIPlugin.getDefault().getLogger().warning("Could not find command with id " + this.m_commandid + " when registring handler.");
        }
    }

    @Override
    public void deactivate() {
        if (this.m_activationHandler != null) {
            this.getSite().getHandlerService().deactivateHandler(this.m_activationHandler);
        }
        this.m_activationHandler = null;
    }
}

