/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.views;

import com.jrockit.mc.ui.handlers.MCContextMenuManager;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.site.SectionSite;
import com.jrockit.mc.ui.site.ServiceRegistry;
import com.jrockit.mc.ui.site.SiteFocusListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public abstract class ViewerPart
extends ViewPart {
    protected Viewer m_viewer;
    private MenuManager m_menuManager;
    private final String m_identifier;
    private SectionSite m_site;

    public ViewerPart(String identifier) {
        this.m_identifier = identifier;
    }

    protected abstract Viewer createViewer(Composite var1);

    protected Composite createViewerClient(Composite section) {
        Composite container = new Composite(section, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout(1));
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        return container;
    }

    public Viewer getViewer() {
        return this.m_viewer;
    }

    protected IToolBarManager getToolbarmanager() {
        return this.getViewSite().getActionBars().getToolBarManager();
    }

    public final void createPartControl(Composite parent) {
        this.m_site = new SectionSite(this.getSectionIdentifier(), this.getSite(), new ServiceRegistry());
        this.createViewerClient(parent);
        this.setupFocousListeners();
        this.setupSelectionProvider();
        this.setupContextMenu();
        this.m_site.activate();
        this.initializePart();
    }

    protected void initializePart() {
    }

    protected void setupFocousListeners() {
        this.getViewer().getControl().addFocusListener((FocusListener)new SiteFocusListener(this.getMCSite()));
    }

    protected String getSectionIdentifier() {
        return this.m_identifier;
    }

    protected void setupSelectionProvider() {
        this.getMCSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected void setupContextMenu() {
        MenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            Control control = this.getViewer().getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
        }
    }

    public SectionSite getMCSite() {
        return this.m_site;
    }

    protected MenuManager getMenuManager() {
        if (this.m_menuManager == null) {
            this.m_menuManager = new MCContextMenuManager(this.getSectionIdentifier());
        }
        return this.m_menuManager;
    }

    public void setFocus() {
        if (this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.m_site.deactivate();
    }
}

