/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.model;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.ui.misc.MCColor;
import java.awt.Color;
import java.util.UUID;

public final class DataSeriesDescriptor {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String FILLED = "filled";
    public static final String TOP_COLOR = "topColor";
    public static final String BOTTOM_COLOR = "bottomColor";
    public static final String DRAW_LINE = "drawLine";
    public static final String LINE_COLOR = "lineColor";
    public static final String STACK = "stack";
    public static final String INTEGRATE = "integrate";
    private static final String STYLE = "style";
    public static final String SHOW_IN_LEGEND = "showInLegend";
    public static final String OPERATIVE_SET = "operativeSet";
    private static final String ID = "id";
    private final Setting m_setting = new Setting("dataSeries");

    static {
        PersistenceToolkit.registerFetcher(DataSeriesDescriptor.class, (ISettingFetcher)new ISettingFetcher<DataSeriesDescriptor>(){

            public Setting getSetting(DataSeriesDescriptor dataSeriesDescriptor) {
                return dataSeriesDescriptor.m_setting;
            }
        });
    }

    public DataSeriesDescriptor() {
        this.setName(Messages.CHART_MODEL_DEFAULT_DATASERIES_NAME_TEXT);
        this.setDescription("");
        this.setFilled(false);
        MCColor fillColor = MCColor.createRandomColor();
        this.setTopColor(fillColor);
        this.setBottomColor(fillColor);
        this.setLineColor(new MCColor(Color.BLACK));
        this.setDrawLine(true);
    }

    public void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public Style getStyle() {
        return Style.toStyle((String)this.m_setting.getChildObject(STYLE, String.class));
    }

    public void setStyle(Style style) {
        this.m_setting.setChildObject(STYLE, (Object)style.key);
    }

    public boolean getFilled() {
        return (Boolean)this.m_setting.getChildObject(FILLED, Boolean.class);
    }

    public void setFilled(boolean filled) {
        this.m_setting.setChildObject(FILLED, (Object)filled);
    }

    public void setTopColor(MCColor color) {
        this.m_setting.setChildObject(TOP_COLOR, (Object)color);
    }

    public MCColor getTopColor() {
        return (MCColor)this.m_setting.getChildObject(TOP_COLOR, MCColor.class);
    }

    public MCColor getBottomColor() {
        return (MCColor)this.m_setting.getChildObject(BOTTOM_COLOR, MCColor.class);
    }

    public void setBottomColor(MCColor color) {
        this.m_setting.setChildObject(BOTTOM_COLOR, (Object)color);
    }

    public boolean getDrawLine() {
        return (Boolean)this.m_setting.getChildObject(DRAW_LINE, Boolean.class);
    }

    public void setDrawLine(boolean draw) {
        this.m_setting.setChildObject(DRAW_LINE, (Object)draw);
    }

    public void setLineColor(MCColor color) {
        this.m_setting.setChildObject(LINE_COLOR, (Object)color);
    }

    public MCColor getLineColor() {
        return (MCColor)this.m_setting.getChildObject(LINE_COLOR, MCColor.class);
    }

    public boolean getShowInLegend() {
        return (Boolean)this.m_setting.getChildObject(SHOW_IN_LEGEND, Boolean.class);
    }

    public void setShowInLegend(boolean showInLegend) {
        this.m_setting.setChildObject(SHOW_IN_LEGEND, (Object)showInLegend);
    }

    public boolean getStack() {
        return (Boolean)this.m_setting.getChildObject(STACK, Boolean.class);
    }

    public void setStack(boolean stack) {
        this.m_setting.setChildObject(STACK, (Object)stack);
    }

    public boolean getOperativeSet() {
        return (Boolean)this.m_setting.getChildObject(OPERATIVE_SET, Boolean.class);
    }

    public void setOperativeSet(boolean os) {
        this.m_setting.setChildObject(OPERATIVE_SET, (Object)os);
    }

    public void ensureId() {
        if (!this.m_setting.hasChild(ID)) {
            this.m_setting.setChildObject(ID, (Object)UUID.randomUUID().toString());
        }
    }

    public String getId() {
        return (String)this.m_setting.getChildObject(ID, String.class);
    }
}

