/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.LockForFile;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.providers.Attributes;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

public abstract class BaseFileObj
extends FileObject {
    private static final String PATH_SEPARATOR = File.separator;
    private static final char EXT_SEP = '.';
    static final Logger LOG = Logger.getLogger(BaseFileObj.class.getName());
    static final long serialVersionUID = -1244650210876356809L;
    static final Attributes attribs;
    private static final Object EVENT_SUPPORT_LOCK;
    private EventListenerList eventSupport;
    private FileNaming fileName;

    protected BaseFileObj(File file) {
        this(file, NamingFactory.fromFile(file));
    }

    protected BaseFileObj(File file, FileNaming fileNaming) {
        assert (fileNaming != null);
        this.fileName = fileNaming;
    }

    public final String toString() {
        return String.format("%s@%h:%h%s", new Object[]{this.fileName, this.fileName, this, this.isValid() ? "" : "[invalid]"});
    }

    public final String getNameExt() {
        String string = this.getFileName().getName();
        while (string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static boolean isUncRoot(File file) {
        File file2;
        if (file.getPath().startsWith("\\\\") && (file2 = file.getParentFile()) != null && (file2 = file2.getParentFile()) != null) {
            return file2.getPath().equals("\\\\");
        }
        return false;
    }

    static String getNameExt(File file) {
        String string;
        String string2 = string = file.getParent() == null || BaseFileObj.isUncRoot(file) ? file.getAbsolutePath() : file.getName();
        if (string.endsWith(PATH_SEPARATOR)) {
            boolean bl;
            boolean bl2 = bl = file.getParent() != null || !new FileInfo(file).isUNCFolder();
            if (bl) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean canRead() {
        File file = this.getFileName().getFile();
        return file.canRead();
    }

    public boolean canWrite() {
        File file = this.getFileName().getFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        return providedExtensions.canWrite(file);
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public final String getName() {
        return FileInfo.getName(this.getNameExt());
    }

    public final String getExt() {
        return FileInfo.getExt(this.getNameExt());
    }

    public final String getPath() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (FileNaming fileNaming = this.getFileName(); fileNaming != null; fileNaming = fileNaming.getParent()) {
            linkedList.addFirst(fileNaming.getName());
        }
        String string = (String)linkedList.removeFirst();
        if (Utilities.isWindows() && (string = string.replace(File.separatorChar, '/')).startsWith("//")) {
            string = string + "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        while (!linkedList.isEmpty()) {
            stringBuilder.append((String)linkedList.removeFirst());
            if (linkedList.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return FileBasedFileSystem.getInstance();
    }

    public final boolean isRoot() {
        return false;
    }

    public final Date lastModified() {
        File file = this.getFileName().getFile();
        long l = file.lastModified();
        return new Date(l);
    }

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        File file = this.getToFile(fileObject, string, string2);
        providedExtensions.beforeCopy(fileObject, file);
        FileObject fileObject2 = null;
        try {
            ProvidedExtensions.IOHandler iOHandler = providedExtensions.getCopyHandler(this.getFileName().getFile(), file);
            if (iOHandler != null) {
                if (fileObject instanceof FolderObj) {
                    fileObject2 = this.handleMoveCopy((FolderObj)fileObject, string, string2, iOHandler);
                } else {
                    iOHandler.handle();
                    this.refresh(true);
                    fileObject.refresh(true);
                    fileObject2 = fileObject.getFileObject(string, string2);
                    assert (fileObject2 != null) : "Cannot find " + fileObject + " with " + string + "." + string2;
                }
                FileUtil.copyAttributes((FileObject)this, (FileObject)fileObject2);
            } else {
                if (this.isFolder() && string2 != null && !string2.isEmpty()) {
                    string = string + '.' + string2;
                }
                fileObject2 = super.copy(fileObject, string, string2);
            }
        }
        catch (IOException iOException) {
            providedExtensions.copyFailure(this, file);
            throw iOException;
        }
        providedExtensions.copySuccess(this, file);
        return fileObject2;
    }

    public final FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        File file = this.getToFile(fileObject, string, string2);
        providedExtensions.beforeMove(this, file);
        FileObject fileObject2 = null;
        try {
            if (!this.checkLock(fileLock)) {
                FSException.io("EXC_InvalidLock", fileLock, this.getPath());
            }
            Watcher.lock(fileObject);
            Watcher.lock(this.getParent());
            ProvidedExtensions.IOHandler iOHandler = providedExtensions.getMoveHandler(this.getFileName().getFile(), file);
            if (iOHandler != null) {
                if (fileObject instanceof FolderObj) {
                    fileObject2 = this.move(fileLock, (FolderObj)fileObject, string, string2, iOHandler);
                } else {
                    iOHandler.handle();
                    this.refresh(true);
                    fileObject.refresh(true);
                    fileObject2 = fileObject.getFileObject(string, string2);
                    assert (fileObject2 != null) : "Cannot find " + fileObject + " with " + string + "." + string2;
                }
            } else {
                fileObject2 = super.move(fileLock, fileObject, string, string2);
            }
            FileUtil.copyAttributes((FileObject)this, (FileObject)fileObject2);
        }
        catch (IOException iOException) {
            providedExtensions.moveFailure(this, file);
            throw iOException;
        }
        providedExtensions.moveSuccess(this, file);
        return fileObject2;
    }

    public BaseFileObj move(FileLock fileLock, FolderObj folderObj, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        return this.handleMoveCopy(folderObj, string, string2, iOHandler);
    }

    private File getToFile(FileObject fileObject, String string, String string2) {
        File file = fileObject instanceof FolderObj ? new File(((BaseFileObj)fileObject).getFileName().getFile(), FileInfo.composeName(string, string2)) : new File(FileUtil.toFile((FileObject)fileObject), FileInfo.composeName(string, string2));
        return file;
    }

    static void dumpFileInfo(File file, Throwable throwable) {
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            if (file2.exists()) {
                Exceptions.attachMessage((Throwable)throwable, (String)("\nParent exists: " + file2));
                Exceptions.attachMessage((Throwable)throwable, (String)("\nHas children " + Arrays.toString(file2.list())));
                break;
            }
            Exceptions.attachMessage((Throwable)throwable, (String)("\nParent does not exist " + file2));
        }
    }

    private BaseFileObj handleMoveCopy(FolderObj folderObj, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        int n;
        iOHandler.handle();
        String string3 = FileInfo.composeName(string, string2);
        folderObj.getChildrenCache().getChild(string3, true);
        BaseFileObj baseFileObj = null;
        File file = new File(folderObj.getFileName().getFile(), string3);
        for (n = 0; n < 10; ++n) {
            baseFileObj = (BaseFileObj)FileBasedFileSystem.getFileObject(file);
            if (baseFileObj != null) {
                if (baseFileObj.isData()) {
                    baseFileObj.fireFileDataCreatedEvent(false);
                    break;
                }
                baseFileObj.fireFileFolderCreatedEvent(false);
                break;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        n = 0;
        if (!$assertionsDisabled) {
            n = 1;
            if (1 == 0) {
                throw new AssertionError();
            }
        }
        if (baseFileObj == null && n != 0) {
            AssertionError assertionError = new AssertionError((Object)("FileObject for " + file + " not found."));
            BaseFileObj.dumpFileInfo(file, (Throwable)((Object)assertionError));
            throw assertionError;
        }
        FolderObj folderObj2 = this.getExistingParent();
        if (folderObj2 != null) {
            folderObj2.refresh(true);
        } else {
            this.refresh(true);
        }
        return baseFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rename(FileLock fileLock, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        Object object;
        Object object2;
        boolean bl;
        String string3;
        Object object3;
        if (!this.checkLock(fileLock)) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath());
        }
        File file = this.getFileName().getFile();
        File file2 = file.getParentFile();
        String string4 = FileInfo.composeName(string, string2);
        if (string4.equals(this.getNameExt())) {
            return;
        }
        File file3 = new File(file2, string4);
        if (file2 == null || !FileChangedManager.getInstance().exists(file2) || string4.contains("/") || string4.contains("\\")) {
            object3 = this.getExistingParent();
            string3 = object3 != null ? object3.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), string3, string4);
        }
        object3 = this.getName();
        string3 = this.getExt();
        if (Utils.equals(file3, file)) {
            boolean bl2;
            if (iOHandler != null) {
                iOHandler.handle();
                bl2 = true;
            } else {
                bl2 = file.renameTo(file3);
            }
            if (!bl2) {
                FolderObj folderObj = this.getExistingParent();
                String string5 = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotRename", file.getName(), string5, string4);
            }
            NamingFactory.checkCaseSensitivity(this.fileName, file3);
            this.fireFileRenamedEvent((String)object3, string3);
            return;
        }
        boolean bl3 = bl = FileChangedManager.getInstance().exists(file3) && !Utils.equals(file3, file);
        if (bl) {
            object2 = this.getExistingParent();
            object = object2 != null ? object2.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), object, string4);
        }
        object2 = this.getFactory();
        object = FileObjectFactory.AllFactories;
        synchronized (object) {
            Object object4;
            FileNaming fileNaming = this.getFileName();
            assert (fileNaming != null);
            FileNaming[] fileNamingArray = NamingFactory.rename(fileNaming, string4, iOHandler);
            if (fileNamingArray == null) {
                object4 = this.getExistingParent();
                String string6 = object4 != null ? object4.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotRename", file.getName(), string6, string4);
            }
            assert (fileNamingArray[0] != null);
            this.fileName = fileNamingArray[0];
            object4 = new HashSet(fileNamingArray.length * 2);
            object4.add(this);
            attribs.renameAttributes(file.getAbsolutePath().replace('\\', '/'), file3.getAbsolutePath().replace('\\', '/'));
            for (int i = 0; i < fileNamingArray.length; ++i) {
                Mutex.Privileged privileged;
                BaseFileObj baseFileObj;
                File file4 = fileNamingArray[i].getFile();
                BaseFileObj baseFileObj2 = ((FileObjectFactory)object2).getCachedOnly(file4, false);
                if (baseFileObj2 != null && i >= 1) {
                    baseFileObj2.updateFileName(fileNamingArray[i], fileNaming, fileNamingArray[0]);
                    object4.add(baseFileObj2);
                }
                BaseFileObj baseFileObj3 = baseFileObj = fileNamingArray[i].getParent() != null ? ((FileObjectFactory)object2).getCachedOnly(file4.getParentFile(), false) : null;
                if (!(baseFileObj instanceof FolderObj)) continue;
                FolderObj folderObj = (FolderObj)baseFileObj;
                ChildrenCache childrenCache = folderObj.getChildrenCache();
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    if (i >= 1) {
                        childrenCache.removeChild(fileNamingArray[i]);
                    }
                    childrenCache.getChild(fileNamingArray[i].getName(), true);
                    continue;
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
            ((FileObjectFactory)object2).rename((Set<BaseFileObj>)object4);
        }
        LockForFile.relock(file, file3);
        this.fireFileRenamedEvent((String)object3, string3);
    }

    public final void rename(final FileLock fileLock, final String string, final String string2) throws IOException {
        FileBasedFileSystem.FSCallable<Boolean> fSCallable = new FileBasedFileSystem.FSCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                ProvidedExtensions providedExtensions = BaseFileObj.this.getProvidedExtensions();
                BaseFileObj.this.rename(fileLock, string, string2, providedExtensions.getRenameHandler(BaseFileObj.this.getFileName().getFile(), FileInfo.composeName(string, string2)));
                return true;
            }
        };
        FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    public Object getAttribute(String string) {
        if (string.equals("FileSystem.rootPath")) {
            return "";
        }
        if (string.equals("java.io.File")) {
            return this.getFileName().getFile();
        }
        if (string.equals("ExistsParentNoPublicAPI")) {
            return this.getExistingParent() != null;
        }
        if (string.startsWith("ProvidedExtensions")) {
            ProvidedExtensions providedExtensions = this.getProvidedExtensions();
            return providedExtensions.getAttribute(this.getFileName().getFile(), string);
        }
        return attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
    }

    public final void setAttribute(String string, Object object) throws IOException {
        Object object2 = attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
        attribs.writeAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string, object);
        this.fireFileAttributeChangedEvent(string, object2, object);
    }

    public final Enumeration<String> getAttributes() {
        return attribs.attributes(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'));
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().add(FileChangeListener.class, fileChangeListener);
        Watcher.register(this);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().remove(FileChangeListener.class, fileChangeListener);
        if (this.noFolderListeners()) {
            Watcher.unregister(this);
        }
    }

    protected abstract boolean noFolderListeners();

    final boolean noListeners() {
        return this.getEventSupport().getListenerCount() == 0;
    }

    public void addRecursiveListener(FileChangeListener fileChangeListener) {
        this.addFileChangeListener(fileChangeListener);
    }

    public void removeRecursiveListener(FileChangeListener fileChangeListener) {
        this.removeFileChangeListener(fileChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<FileChangeListener> getListeners() {
        Object object = EVENT_SUPPORT_LOCK;
        synchronized (object) {
            if (this.eventSupport == null) {
                return Enumerations.empty();
            }
            return Enumerations.array((Object[])this.eventSupport.getListeners(FileChangeListener.class));
        }
    }

    public final long getSize() {
        return this.getFileName().getFile().length();
    }

    public final void setImportant(boolean bl) {
    }

    public boolean isReadOnly() {
        File file = this.getFileName().getFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        return !providedExtensions.canWrite(file) && FileChangedManager.getInstance().exists(file);
    }

    public final FileObject getParent() {
        Object object = null;
        if (!this.isRoot()) {
            FileNaming fileNaming = this.getFileName().getParent();
            if (Utilities.isWindows()) {
                File file;
                FileObjectFactory fileObjectFactory;
                object = fileNaming == null ? FileBasedFileSystem.getInstance().getRoot() : ((object = (fileObjectFactory = this.getFactory()).getCachedOnly(file = fileNaming.getFile())) == null ? fileObjectFactory.getFileObject(new FileInfo(file), FileObjectFactory.Caller.GetParent) : object);
            } else if (fileNaming != null) {
                FileObjectFactory fileObjectFactory = this.getFactory();
                File file = fileNaming.getFile();
                if (file.getParentFile() == null) {
                    object = FileBasedFileSystem.getInstance().getRoot();
                } else {
                    object = fileObjectFactory.getCachedOnly(file);
                    FileObject fileObject = object = object == null ? fileObjectFactory.getFileObject(new FileInfo(file), FileObjectFactory.Caller.GetParent) : object;
                }
            }
            assert (object != null) : "getParent should not return null for " + (Object)((Object)this);
        }
        return object;
    }

    static File getFile(File file, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append('.');
            stringBuffer.append(string2);
        }
        File file2 = new File(file, stringBuffer.toString());
        return file2;
    }

    public final FileObjectFactory getFactory() {
        return FileObjectFactory.getInstance(this.getFileName().getFile());
    }

    final void fireFileDataCreatedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration<FileChangeListener> enumeration = folderObj != null ? super.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (folderObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(folderObj, this, bl, 0L);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileDataCreatedEvent(this.getListeners(), fileEventImpl2);
            folderObj.fireFileDataCreatedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl, 0L);
            this.fireFileDataCreatedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
        LOG.log(Level.FINER, "fireFileDataCreatedEvent {0}", (Object)this);
    }

    final void fireFileFolderCreatedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration<FileChangeListener> enumeration = folderObj != null ? super.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (folderObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(folderObj, this, bl, 0L);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileFolderCreatedEvent(this.getListeners(), fileEventImpl2);
            folderObj.fireFileFolderCreatedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl, 0L);
            this.fireFileFolderCreatedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
        LOG.log(Level.FINER, "fireFileFolderCreatedEvent {0}", (Object)this);
    }

    public final void fireFileChangedEvent(boolean bl) {
        this.getProvidedExtensions().fileChanged(this);
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        BaseFileObj baseFileObj = folderObj instanceof BaseFileObj ? folderObj : null;
        Enumeration<FileChangeListener> enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (baseFileObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(baseFileObj, this, bl, this.lastModified().getTime());
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileChangedEvent(this.getListeners(), fileEventImpl2);
            baseFileObj.fireFileChangedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl, this.lastModified().getTime());
            this.fireFileChangedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
        LOG.log(Level.FINER, "fireFileChangedEvent {0}", (Object)this);
    }

    final void fireFileDeletedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        BaseFileObj baseFileObj = folderObj instanceof BaseFileObj ? folderObj : null;
        Enumeration<FileChangeListener> enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (baseFileObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(baseFileObj, this, bl, 0L);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileDeletedEvent(this.getListeners(), fileEventImpl2);
            baseFileObj.fireFileDeletedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl, 0L);
            this.fireFileDeletedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
        LOG.log(Level.FINER, "fireFileDeletedEvent {0}", (Object)this);
    }

    private void fireFileRenamedEvent(String string, String string2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration<FileChangeListener> enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this, string, string2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileRenamedEvent(enumeration, new FileRenameEvent((FileObject)folderObj, (FileObject)this, string, string2));
        }
        stopWatch.stop();
        LOG.log(Level.FINER, "fireFileRenamedEvent {0} oldName {1} ext {2}", new Object[]{this, string, string2});
    }

    final void fireFileAttributeChangedEvent(String string, Object object, Object object2) {
        FolderObj folderObj = this.getExistingParent();
        Enumeration<FileChangeListener> enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, string, object, object2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileAttributeChangedEvent(enumeration, new FileAttributeEvent((FileObject)folderObj, (FileObject)this, string, object, object2));
        }
        LOG.log(Level.FINER, "fireFileAttributeChangedEvent {0} attribute {1}", new Object[]{this, string});
    }

    public final FileNaming getFileName() {
        return this.fileName;
    }

    public final void delete(final FileLock fileLock) throws IOException {
        FileBasedFileSystem.FSCallable<Boolean> fSCallable = new FileBasedFileSystem.FSCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                ProvidedExtensions providedExtensions = BaseFileObj.this.getProvidedExtensions();
                providedExtensions.beforeDelete(BaseFileObj.this);
                try {
                    BaseFileObj.this.delete(fileLock, providedExtensions.getDeleteHandler(BaseFileObj.this.getFileName().getFile()));
                }
                catch (IOException iOException) {
                    BaseFileObj.this.getProvidedExtensions().deleteFailure(BaseFileObj.this);
                    throw iOException;
                }
                BaseFileObj.this.getProvidedExtensions().deleteSuccess(BaseFileObj.this);
                return true;
            }
        };
        FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock fileLock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Mutex.Privileged privileged;
        File file = this.getFileName().getFile();
        FolderObj folderObj = this.getExistingParent();
        ChildrenCache childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
        Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
        if (privileged != null) {
            privileged.enterWriteAccess();
        }
        try {
            boolean bl;
            if (!this.checkLock(fileLock)) {
                FSException.io("EXC_InvalidLock", fileLock, this.getPath());
            }
            boolean bl2 = bl = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
            if (!bl) {
                FolderObj folderObj2 = this.getExistingParent();
                String string = folderObj2 != null ? folderObj2.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotDelete", file.getName(), string);
            }
            attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
            if (childrenCache != null) {
                if (deleteHandler != null) {
                    childrenCache.removeChild(this.getFileName());
                } else {
                    childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                }
            }
        }
        finally {
            if (privileged != null) {
                privileged.exitWriteAccess();
            }
        }
        this.setValid(false);
        this.fireFileDeletedEvent(false);
    }

    abstract boolean checkLock(FileLock var1) throws IOException;

    public Object writeReplace() {
        return new ReplaceForSerialization(this.getFileName().getFile());
    }

    protected abstract void setValid(boolean var1);

    abstract void refreshImpl(boolean var1, boolean var2);

    public boolean isValid() {
        return NamingFactory.isValid(this.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(boolean bl, boolean bl2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FILE);
        stopWatch.start();
        try {
            if (this.isValid()) {
                this.refreshImpl(bl, bl2);
                if (this.isValid()) {
                    boolean bl3;
                    File file = this.getFileName().getFile();
                    boolean bl4 = file.isDirectory();
                    if (bl4 == (bl3 = file.isFile()) || this.isFolder() != bl4 || this.isData() != bl3) {
                        this.invalidateFO(bl2, bl);
                    }
                } else if (this.isData()) {
                    this.refreshExistingParent(bl, bl2);
                }
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    void refreshExistingParent(boolean bl, boolean bl2) {
        boolean bl3 = FileChangedManager.getInstance().exists(this.getFileName().getFile());
        if (!bl3) {
            this.invalidateFO(bl2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateFO(boolean bl, boolean bl2) {
        Object object;
        FolderObj folderObj = this.getExistingParent();
        if (folderObj != null) {
            Mutex.Privileged privileged;
            object = folderObj.getChildrenCache();
            Mutex.Privileged privileged2 = privileged = object != null ? object.getMutexPrivileged() : null;
            if (privileged != null) {
                privileged.enterWriteAccess();
            }
            try {
                object.getChild(this.getFileName().getFile().getName(), true);
            }
            finally {
                if (privileged != null) {
                    privileged.exitWriteAccess();
                }
            }
        }
        this.setValid(false);
        object = NamingFactory.fromFile(this.getFileName().getParent(), this.getFileName().getFile(), true);
        if (bl) {
            this.getProvidedExtensions().deletedExternally(this);
            this.fireFileDeletedEvent(bl2);
        }
    }

    private void updateFileName(FileNaming fileNaming, FileNaming fileNaming2, FileNaming fileNaming3) {
        Stack<String> stack = new Stack<String>();
        while (fileNaming2 != fileNaming && fileNaming != null) {
            stack.add(fileNaming.getName());
            fileNaming = fileNaming.getParent();
        }
        File file = fileNaming3.getFile();
        while (!stack.isEmpty()) {
            String string = (String)stack.pop();
            file = new File(file, string);
            fileNaming3 = NamingFactory.fromFile(fileNaming3, file, true);
        }
        assert (fileNaming3 != null);
        this.fileName = fileNaming3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventListenerList getEventSupport() {
        Object object = EVENT_SUPPORT_LOCK;
        synchronized (object) {
            if (this.eventSupport == null) {
                this.eventSupport = new EventListenerList();
            }
            return this.eventSupport;
        }
    }

    final ProvidedExtensions getProvidedExtensions() {
        FileBasedFileSystem.StatusImpl statusImpl = (FileBasedFileSystem.StatusImpl)FileBasedFileSystem.getInstance().getStatus();
        ProvidedExtensions providedExtensions = statusImpl.getExtensions();
        return providedExtensions;
    }

    public static FolderObj getExistingFor(File file, FileObjectFactory fileObjectFactory) {
        if (fileObjectFactory == null) {
            throw new NullPointerException("No factory for " + file);
        }
        BaseFileObj baseFileObj = fileObjectFactory.getCachedOnly(file);
        return (FolderObj)(baseFileObj instanceof FolderObj ? baseFileObj : null);
    }

    public static FolderObj getExistingParentFor(File file, FileObjectFactory fileObjectFactory) {
        File file2 = file.getParentFile();
        return file2 == null ? null : BaseFileObj.getExistingFor(file2, fileObjectFactory);
    }

    FolderObj getExistingParent() {
        return BaseFileObj.getExistingParentFor(this.getFileName().getFile(), this.getFactory());
    }

    static {
        BridgeForAttributes bridgeForAttributes = new BridgeForAttributes();
        attribs = new Attributes(bridgeForAttributes, bridgeForAttributes, bridgeForAttributes);
        EVENT_SUPPORT_LOCK = new Object();
    }

    private static final class Delivered
    implements FileChangeListener {
        private Delivered() {
        }

        private void unlock(FileEvent fileEvent) {
            Watcher.unlock((FileObject)fileEvent.getSource());
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.unlock(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.unlock(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.unlock(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.unlock(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.unlock((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.unlock((FileEvent)fileAttributeEvent);
        }
    }

    private static class FileEventImpl
    extends FileEvent
    implements Enumeration<FileEvent> {
        private FileEventImpl next;

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public FileEvent nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public FileEventImpl(FileObject fileObject, FileObject fileObject2, boolean bl, long l) {
            super(fileObject, fileObject2, bl, l);
        }

        public FileEventImpl(FileObject fileObject, FileEventImpl fileEventImpl) {
            super(fileObject, fileEventImpl.getFile(), fileEventImpl.isExpected(), fileEventImpl.getTime());
            this.next = fileEventImpl;
        }

        static {
            FileBasedFileSystem.getInstance().addFileChangeListener(new Delivered());
        }
    }

    private static final class BridgeForAttributes
    implements AbstractFileSystem.List,
    AbstractFileSystem.Change,
    AbstractFileSystem.Info {
        private BridgeForAttributes() {
        }

        public final Date lastModified(String string) {
            File file = new File(string);
            return new Date(file.lastModified());
        }

        public final boolean folder(String string) {
            File file = new File(string);
            return file.isDirectory();
        }

        public final boolean readOnly(String string) {
            File file = new File(string);
            return !file.canWrite();
        }

        public final String mimeType(String string) {
            return "content/unknown";
        }

        public final long size(String string) {
            File file = new File(string);
            return file.length();
        }

        public final InputStream inputStream(String string) throws FileNotFoundException {
            File file = new File(string);
            return new FileInputStream(file);
        }

        public final OutputStream outputStream(String string) throws IOException {
            File file = new File(string);
            return new FileOutputStream(file);
        }

        public final void lock(String string) throws IOException {
        }

        public final void unlock(String string) {
        }

        public final void markUnimportant(String string) {
        }

        public final String[] children(String string) {
            File file = new File(string);
            return file.list();
        }

        public final void createFolder(String string) throws IOException {
            File file = new File(string);
            if (!file.mkdirs()) {
                IOException iOException = new IOException(string);
                throw iOException;
            }
        }

        public final void createData(String string) throws IOException {
            File file = new File(string);
            if (!file.createNewFile()) {
                throw new IOException(string);
            }
        }

        public final void rename(String string, String string2) throws IOException {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.renameTo(file2)) {
                FSException.io("EXC_CannotRename", file.getName(), "", file2.getName());
            }
        }

        public final void delete(String string) throws IOException {
            boolean bl;
            File file = new File(string);
            boolean bl2 = bl = file.isFile() ? file.delete() : this.deleteFolder(file);
            if (bl) {
                FSException.io("EXC_CannotDelete", file.getName(), "");
            }
        }

        private boolean deleteFolder(File file) throws IOException {
            File[] fileArray;
            boolean bl = file.delete();
            if (bl) {
                return true;
            }
            if (!FileChangedManager.getInstance().exists(file)) {
                return false;
            }
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (this.deleteFolder(file2)) continue;
                    return false;
                }
            }
            return file.delete();
        }
    }
}

