/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectKeeper;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public final class FolderObj
extends BaseFileObj {
    static final long serialVersionUID = -1022430210876356809L;
    private static final Logger LOG = Logger.getLogger(FolderObj.class.getName());
    private FolderChildrenCache folderChildren;
    boolean valid = true;
    private volatile FileObjectKeeper keeper;

    public FolderObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
    }

    public final boolean isFolder() {
        return true;
    }

    public FileObject getFileObject(String string) {
        if (string.equals(".")) {
            return this;
        }
        if (string.indexOf(92) != -1) {
            return null;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        File file = new File(this.getFileName().getFile(), string);
        if (string.contains("..") || string.contains("./") || string.contains("/.")) {
            file = FileUtil.normalizeFile((File)file);
        }
        FileObjectFactory fileObjectFactory = this.getFactory();
        assert (fileObjectFactory != null) : "No factory for " + this.getPath() + " this: " + (Object)((Object)this);
        return fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public final FileObject getFileObject(String string, String string2) {
        File file = BaseFileObj.getFile(this.getFileName().getFile(), string, string2);
        FileObjectFactory fileObjectFactory = this.getFactory();
        return string.indexOf("/") == -1 ? fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject) : null;
    }

    @Override
    protected boolean noFolderListeners() {
        if (this.noListeners()) {
            for (FileObject fileObject : this.computeChildren(true)) {
                BaseFileObj baseFileObj;
                if (!(fileObject instanceof BaseFileObj) || (baseFileObj = (BaseFileObj)fileObject).noListeners()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final FileObject[] getChildren() {
        return this.computeChildren(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject[] computeChildren(boolean bl) {
        int n = 0;
        while (true) {
            block13: {
                Set<FileNaming> set;
                LinkedHashMap<FileNaming, BaseFileObj> linkedHashMap = new LinkedHashMap<FileNaming, BaseFileObj>();
                ChildrenCache childrenCache = this.getChildrenCache();
                Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
                HashSet hashSet = null;
                Runnable[] runnableArray = new Runnable[1];
                while (hashSet == null) {
                    if (runnableArray[0] != null) {
                        runnableArray[0].run();
                    }
                    privileged.enterWriteAccess();
                    try {
                        set = childrenCache.getChildren(n >= 10, runnableArray);
                        if (set == null) continue;
                        hashSet = new HashSet(set);
                    }
                    finally {
                        privileged.exitWriteAccess();
                    }
                }
                LOG.log(Level.FINEST, "computeChildren, filenames: {0}", hashSet);
                set = this.getFactory();
                for (FileNaming fileNaming : hashSet) {
                    FileInfo fileInfo = new FileInfo(fileNaming.getFile(), 1);
                    fileInfo.setFileNaming(fileNaming);
                    BaseFileObj baseFileObj = bl ? ((FileObjectFactory)((Object)set)).getCachedOnly(fileNaming.getFile()) : ((FileObjectFactory)((Object)set)).getFileObject(fileInfo, FileObjectFactory.Caller.GetChildern);
                    if (baseFileObj == null) continue;
                    FileNaming fileNaming2 = baseFileObj.getFileName();
                    if (!baseFileObj.isValid()) {
                        Level level = n < 10 ? Level.FINE : Level.WARNING;
                        LOG.log(level, "Invalid fileObject {0}, trying again for {1} with {2}", new Object[]{baseFileObj, n, bl});
                        if (n > 5) {
                            bl = false;
                        }
                        assert (n < 100);
                        if (n < 100) break block13;
                    }
                    if (fileNaming == fileNaming2 || n >= 10) {
                        assert (fileNaming == fileNaming2) : FolderObj.dumpFileNaming(fileNaming) + "\n" + FolderObj.dumpFileNaming(baseFileObj.getFileName()) + "\nfo: " + (Object)((Object)baseFileObj) + "\nContent of the nameMap cache:\n" + NamingFactory.dumpId(fileInfo.getID());
                        linkedHashMap.put(fileNaming, baseFileObj);
                        continue;
                    }
                    break block13;
                }
                return linkedHashMap.values().toArray(new FileObject[0]);
            }
            ++n;
        }
    }

    private static String dumpFileNaming(FileNaming fileNaming) {
        if (fileNaming == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FileName: ").append(fileNaming).append("#").append(Integer.toHexString(fileNaming.hashCode())).append("@").append(Integer.toHexString(System.identityHashCode(fileNaming))).append("\n");
        if (fileNaming instanceof FileName) {
            ((FileName)fileNaming).dumpCreation(stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createFolderImpl(String string) throws IOException {
        Object object;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        BaseFileObj baseFileObj = null;
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        File file = this.getFileName().getFile();
        File file2 = BaseFileObj.getFile(file, string, null);
        this.getProvidedExtensions().beforeCreate(this, file2.getName(), true);
        privileged.enterWriteAccess();
        try {
            if (!file.canWrite()) {
                FSException.io("EXC_CannotCreateFolder", file2.getName(), this.getPath());
            }
            Watcher.lock(this);
            this.createFolder(file2, string);
            object = this.getChildrenCache().getChild(file2.getName(), true);
            if (object != null && !object.isDirectory()) {
                object = NamingFactory.fromFile(this.getFileName(), file2, true);
            }
            if (object != null) {
                object = NamingFactory.checkCaseSensitivity((FileNaming)object, file2);
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        object = this.getFactory();
        if (object != null) {
            BaseFileObj baseFileObj2 = ((FileObjectFactory)object).getValidFileObject(file2, FileObjectFactory.Caller.Others);
            if (baseFileObj2 instanceof FolderObj) {
                baseFileObj = (FolderObj)baseFileObj2;
            } else {
                FSException.io("EXC_CannotCreateFolder", file2.getName(), this.getPath());
            }
        }
        if (baseFileObj != null) {
            baseFileObj.fireFileFolderCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateFolder", file2.getName(), this.getPath());
        }
        this.getProvidedExtensions().createSuccess(baseFileObj);
        return baseFileObj;
    }

    private void createFolder(File file, String string) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        if (!bl) {
            providedExtensions.createFailure(this, file.getName(), true);
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(file)) {
                providedExtensions.createFailure(this, file.getName(), true);
                throw new SyncFailedException(file.getAbsolutePath());
            }
            if (!file.mkdirs()) {
                providedExtensions.createFailure(this, file.getName(), true);
                FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
            }
        }
        LogRecord logRecord = new LogRecord(Level.FINEST, "FolderCreated: " + file.getAbsolutePath());
        logRecord.setParameters(new Object[]{file});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(logRecord);
    }

    public final FileObject createData(final String string, final String string2) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> fSCallable = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createDataImpl(string, string2);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    public final FileObject createFolder(final String string) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> fSCallable = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createFolderImpl(string);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createDataImpl(String string, String string2) throws IOException {
        FileNaming fileNaming;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IOException("Requested name contains invalid characters: " + string);
        }
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        File file = BaseFileObj.getFile(this.getFileName().getFile(), string, string2);
        providedExtensions.beforeCreate(this, file.getName(), false);
        privileged.enterWriteAccess();
        try {
            Watcher.lock(this);
            this.createData(file);
            fileNaming = this.getChildrenCache().getChild(file.getName(), true);
            if (fileNaming != null && fileNaming.isDirectory()) {
                fileNaming = NamingFactory.fromFile(this.getFileName(), file, true);
            }
            if (fileNaming != null) {
                fileNaming = NamingFactory.checkCaseSensitivity(fileNaming, file);
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        FileObjectFactory fileObjectFactory = this.getFactory();
        BaseFileObj baseFileObj = null;
        if (fileObjectFactory != null) {
            BaseFileObj baseFileObj2 = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.Others);
            try {
                baseFileObj = (FileObj)baseFileObj2;
            }
            catch (ClassCastException classCastException) {
                boolean bl = file.isDirectory();
                boolean bl2 = file.isFile();
                Exceptions.attachMessage((Throwable)classCastException, (String)("isDir: " + bl));
                Exceptions.attachMessage((Throwable)classCastException, (String)("isFile: " + bl2));
                Exceptions.attachMessage((Throwable)classCastException, (String)("file: " + file));
                Exceptions.attachMessage((Throwable)classCastException, (String)("fo: " + (Object)((Object)baseFileObj2)));
                Exceptions.attachMessage((Throwable)classCastException, (String)("fn: " + Integer.toHexString(System.identityHashCode(fileNaming))));
                Exceptions.attachMessage((Throwable)classCastException, (String)("dump: " + NamingFactory.dumpId(fileNaming.getId())));
                throw classCastException;
            }
        }
        if (baseFileObj != null) {
            if (baseFileObj instanceof FileObj) {
                ((FileObj)baseFileObj).setLastModified(file.lastModified(), file, false);
            }
            baseFileObj.fireFileDataCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        }
        this.getProvidedExtensions().createSuccess(baseFileObj);
        return baseFileObj;
    }

    private void createData(File file) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        if (!bl) {
            providedExtensions.createFailure(this, file.getName(), false);
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(file)) {
                providedExtensions.createFailure(this, file.getName(), false);
                throw new SyncFailedException(file.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                providedExtensions.createFailure(this, file.getName(), false);
                FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
            }
        }
        LogRecord logRecord = new LogRecord(Level.FINEST, "DataCreated: " + file.getAbsolutePath());
        logRecord.setParameters(new Object[]{file});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FileLock fileLock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Object object;
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        File file = this.getFileName().getFile();
        if (!this.deleteFile(file, linkedList, this.getFactory(), deleteHandler)) {
            FolderObj folderObj = this.getExistingParent();
            object = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotDelete", file.getName(), object);
        }
        BaseFileObj.attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
        this.setValid(false);
        for (int i = 0; i < linkedList.size(); ++i) {
            ChildrenCache childrenCache;
            object = (BaseFileObj)linkedList.get(i);
            FolderObj folderObj = ((BaseFileObj)((Object)object)).getExistingParent();
            ChildrenCache childrenCache2 = childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
            if (childrenCache != null) {
                Mutex.Privileged privileged;
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    if (deleteHandler != null) {
                        childrenCache.removeChild(((BaseFileObj)((Object)object)).getFileName());
                    } else {
                        childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                    }
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
            ((BaseFileObj)((Object)object)).setValid(false);
            ((BaseFileObj)((Object)object)).fireFileDeletedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshImpl(boolean bl, boolean bl2) {
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        long l = this.keeper == null ? -1L : this.keeper.childrenLastModified();
        Set<FileNaming> set = null;
        Map<FileNaming, Integer> map = null;
        Runnable[] runnableArray = new Runnable[1];
        while (map == null) {
            if (runnableArray[0] != null) {
                runnableArray[0].run();
            }
            privileged.enterWriteAccess();
            try {
                set = childrenCache.getCachedChildren();
                map = childrenCache.refresh(runnableArray);
            }
            finally {
                privileged.exitWriteAccess();
            }
        }
        LOG.log(Level.FINER, "refreshImpl for {0} expected: {1} fire: {2} previous: {3}", new Object[]{this, bl, bl2, l});
        set.removeAll(map.keySet());
        for (FileNaming object : set) {
            BaseFileObj baseFileObj = this.getFactory().getCachedOnly(object.getFile());
            if (baseFileObj == null || !baseFileObj.isData()) continue;
            ((FileObj)baseFileObj).refresh(bl);
        }
        FileObjectFactory fileObjectFactory = this.getFactory();
        for (Map.Entry<FileNaming, Integer> entry : map.entrySet()) {
            FileNaming fileNaming = entry.getKey();
            Integer n = entry.getValue();
            BaseFileObj baseFileObj = n == ChildrenCache.ADDED_CHILD ? fileObjectFactory.getFileObject(new FileInfo(fileNaming.getFile()), FileObjectFactory.Caller.Others) : fileObjectFactory.getCachedOnly(fileNaming.getFile());
            BaseFileObj baseFileObj2 = baseFileObj = baseFileObj != null ? baseFileObj : this.getFileObject(fileNaming.getName());
            if (n == ChildrenCache.ADDED_CHILD && baseFileObj != null) {
                if (baseFileObj.isFolder()) {
                    if (!bl2) continue;
                    this.getProvidedExtensions().createdExternally(baseFileObj);
                    baseFileObj.fireFileFolderCreatedEvent(bl);
                    continue;
                }
                if (!bl2) continue;
                this.getProvidedExtensions().createdExternally(baseFileObj);
                baseFileObj.fireFileDataCreatedEvent(bl);
                continue;
            }
            if (n != ChildrenCache.REMOVED_CHILD) continue;
            if (baseFileObj != null) {
                if (!baseFileObj.isValid()) continue;
                baseFileObj.setValid(false);
                if (baseFileObj instanceof FolderObj) {
                    this.getProvidedExtensions().deletedExternally(baseFileObj);
                    ((FolderObj)baseFileObj).refreshImpl(bl, bl2);
                    continue;
                }
                if (!bl2) continue;
                this.getProvidedExtensions().deletedExternally(baseFileObj);
                baseFileObj.fireFileDeletedEvent(bl);
                continue;
            }
            File file = fileNaming.getFile();
            if (new FileInfo(file).isConvertibleToFileObject()) continue;
            BaseFileObj baseFileObj3 = fileNaming.isFile() ? new FileObj(file, fileNaming) : new FolderObj(file, fileNaming);
            baseFileObj3.setValid(false);
            if (!bl2) continue;
            baseFileObj3.fireFileDeletedEvent(bl);
        }
        boolean bl3 = FileChangedManager.getInstance().exists(this.getFileName().getFile());
        if (!bl3) {
            this.setValid(false);
            if (bl2) {
                this.fireFileDeletedEvent(bl);
            }
        }
        if (l != -1L) {
            assert (this.keeper != null);
            this.keeper.init(l, fileObjectFactory, bl);
        }
    }

    public final void refresh(boolean bl) {
        this.refresh(bl, true);
    }

    private boolean deleteFile(File file, LinkedList<FileObject> linkedList, FileObjectFactory fileObjectFactory, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        BaseFileObj baseFileObj;
        boolean bl;
        File[] fileArray;
        boolean bl2;
        boolean bl3 = bl2 = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (bl2) {
            BaseFileObj baseFileObj2 = fileObjectFactory.getCachedOnly(file);
            if (baseFileObj2 != null) {
                linkedList.addFirst(baseFileObj2);
            }
            return true;
        }
        if (!FileChangedManager.getInstance().exists(file)) {
            return false;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (this.deleteFile(file2, linkedList, fileObjectFactory, deleteHandler)) continue;
                return false;
            }
        }
        boolean bl4 = bl = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (bl && (baseFileObj = fileObjectFactory.getCachedOnly(file)) != null) {
            linkedList.addFirst(baseFileObj);
        }
        return true;
    }

    @Override
    protected void setValid(boolean bl) {
        if (bl) {
            assert (this.isValid()) : this.toString();
        } else {
            this.valid = false;
        }
    }

    @Override
    public boolean isValid() {
        return this.valid && super.isValid();
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileLock lock() throws IOException {
        return new FileLock();
    }

    @Override
    final boolean checkLock(FileLock fileLock) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChildrenCache getChildrenCache() {
        Class<FolderChildrenCache> clazz = FolderChildrenCache.class;
        synchronized (FolderChildrenCache.class) {
            if (this.folderChildren == null) {
                this.folderChildren = new FolderChildrenCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.folderChildren;
        }
    }

    public final boolean hasRecursiveListener() {
        FileObjectKeeper fileObjectKeeper = this.keeper;
        return fileObjectKeeper != null && fileObjectKeeper.isOn();
    }

    final synchronized FileObjectKeeper getKeeper(Collection<? super File> collection) {
        if (this.keeper == null) {
            this.keeper = new FileObjectKeeper(this);
            List<File> list = this.keeper.init(-1L, null, false);
            if (collection != null) {
                collection.addAll(list);
            }
        } else if (collection != null) {
            List<File> list = this.keeper.init(this.keeper.childrenLastModified(), null, false);
            collection.addAll(list);
        }
        return this.keeper;
    }

    @Override
    public final void addRecursiveListener(FileChangeListener fileChangeListener) {
        this.getKeeper(null).addRecursiveListener(fileChangeListener);
    }

    @Override
    public final void removeRecursiveListener(FileChangeListener fileChangeListener) {
        this.getKeeper(null).removeRecursiveListener(fileChangeListener);
    }

    public final class FolderChildrenCache
    extends ChildrenSupport
    implements ChildrenCache {
        @Override
        public final Set<FileNaming> getChildren(boolean bl, Runnable[] runnableArray) {
            return this.getChildren(FolderObj.this.getFileName(), bl, runnableArray);
        }

        @Override
        public final FileNaming getChild(String string, boolean bl) {
            return this.getChild(string, FolderObj.this.getFileName(), bl);
        }

        @Override
        public final Map<FileNaming, Integer> refresh(Runnable[] runnableArray) {
            return this.refresh(FolderObj.this.getFileName(), runnableArray);
        }

        @Override
        public final String toString() {
            return FolderObj.this.getFileName().toString();
        }

        @Override
        public void removeChild(FileNaming fileNaming) {
            this.removeChild(FolderObj.this.getFileName(), fileNaming);
        }
    }
}

