/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCColor;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class AbstractFlightRecordingEditor
extends DesignEditor {
    public AbstractFlightRecordingEditor() {
        this.setNavigatorPosition("left");
        this.setTabPosition("bottom");
    }

    protected Job initialize(IServiceLocator locator) throws PartInitException {
        Job initJob = null;
        final File file = this.getActiveFile();
        if (file != null) {
            initJob = new Job(MessageFormat.format(Messages.FILE_OPENER_LOAD_JOB_TITLE, file.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        FlightRecording recording = AbstractFlightRecordingEditor.this.createRecording(file, monitor);
                        AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)recording);
                        AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)new StartService(recording));
                        AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)AbstractFlightRecordingEditor.this.createTyperepository(recording));
                        AbstractFlightRecordingEditor.this.showView();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception e) {
                        IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : new Status(4, "com.jrockit.mc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_COULD_NOT_LOAD_FILE, file.getName()), (Throwable)e);
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            initJob.setUser(true);
            this.setPartName(file.getName());
        } else {
            this.setPartName(this.getEditorInput().getName());
        }
        return initJob;
    }

    private static File getExistingFile(File file) throws PartInitException {
        if (!file.exists()) {
            File relativeFile = new File(CorePlugin.getDefault().getWorkspaceDirectory(), file.getPath());
            if (relativeFile.exists() && relativeFile.length() > 0L) {
                return relativeFile;
            }
            throw new PartInitException(String.valueOf(Messages.FILE_OPENER_COULD_NOT_FIND_FILE) + " " + file.getPath());
        }
        if (file.length() == 0L) {
            throw new PartInitException(MessageFormat.format(Messages.FILE_OPENER_NO_DATA_IN_FILE_X_TEXT, file.toString()));
        }
        return file;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public File getActiveFile() throws PartInitException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IPathEditorInput) {
            return AbstractFlightRecordingEditor.getExistingFile(((IPathEditorInput)editorInput).getPath().toFile());
        }
        return null;
    }

    public void setActiveFile(File activeFile) {
        if (this.getEditorInput() instanceof MCPathEditorInput) {
            MCPathEditorInput newEditorInput = new MCPathEditorInput((IPath)new Path(activeFile.getAbsolutePath()), this.getEditorInput().getPersistable() != null);
            this.setInput((IEditorInput)newEditorInput);
        }
        this.setPartName(activeFile.getName());
    }

    private void showView() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractFlightRecordingEditor.this.getSite().getWorkbenchWindow().getActivePage().showView("com.jrockit.mc.flightrecorder.ui.views.types.EventTypesView");
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    protected abstract FlightRecording createRecording(File var1, IProgressMonitor var2) throws Exception;

    private TypeRespository createTyperepository(FlightRecording recording) {
        TypeRespository tr = new TypeRespository();
        for (IEventType type : recording.getEventTypes()) {
            tr.addTypeDescriptor(this.createTypeDescriptor(type));
        }
        return tr;
    }

    private TypeDescriptor createTypeDescriptor(IEventType eventType) {
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        typeDescriptor.setName(eventType.getName());
        typeDescriptor.setDescription(eventType.getDescription());
        typeDescriptor.setChecked(this.enabledByDefault(eventType.getPath()));
        typeDescriptor.setColor(new MCColor(eventType.getColor()));
        typeDescriptor.setPath(eventType.getPath());
        typeDescriptor.setDiscovered(true);
        return typeDescriptor;
    }

    protected boolean enabledByDefault(String path) {
        return path != null && path.startsWith("java") && !path.startsWith("java/statistics");
    }
}

