/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.components.ui.design.IComponentVerifier;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.FlightRecordingLoader;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.AbstractFlightRecordingEditor;
import com.jrockit.mc.flightrecorder.ui.ProgressMonitorAdapter;
import com.jrockit.mc.flightrecorder.ui.SelectRangeWizardPage;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public final class FlightRecordingEditor
extends AbstractFlightRecordingEditor {
    public static final String EDITOR_ID = "com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor";

    private void checkForJRockitRecording(FlightRecording recording, IProgressMonitor monitor) throws Exception {
        for (IProducer producer : recording.getProducers()) {
            if (!producer.getName().contains("JRockit")) continue;
            DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)FlightRecordingEditor.this.getSite().getShell(), (String)Messages.FILE_OPENER_JROCKIT_TITLE, (String)Messages.FILE_OPENER_JROCKIT_TEXT);
                }
            });
            monitor.setCanceled(true);
            throw new OperationCanceledException();
        }
    }

    @Override
    protected FlightRecording createRecording(File file, IProgressMonitor monitor) throws Exception {
        File unzippedFile = this.handleZippedFile(file, monitor);
        FlightRecording rec = this.doCreateRecording(unzippedFile, monitor);
        this.checkForJRockitRecording(rec, monitor);
        ComponentVerifier cv = new ComponentVerifier(rec);
        if (!cv.enabledEventTypes.isEmpty()) {
            this.getServiceLocator().registerService(IComponentVerifier.class, (Object)cv);
        }
        this.checkForLostEvents(rec);
        return rec;
    }

    private ITimeRange selectRangeWizard(double loadQuota, ITimeRange range) {
        SelectRangeWizardPage rangeWizard = new SelectRangeWizardPage(loadQuota, range);
        final OnePageWizardDialog dialog = new OnePageWizardDialog(this.getSite().getShell(), (IWizardPage)rangeWizard);
        dialog.setWidthConstraint(600, 600);
        dialog.setHeightConstraint(400, 400);
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        if (dialog.getReturnCode() == 0) {
            return rangeWizard.getRange();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private FlightRecording doCreateRecording(File file, IProgressMonitor monitor) throws Exception {
        FlightRecordingLoader loader = null;
        double memoryToFileSizeRatio = 2.0;
        while (true) {
            FlightRecording flightRecording;
            try {
                loader = new FlightRecordingLoader(file, (FlightRecordingLoader.ILoadingMonitor)new ProgressMonitorAdapter(monitor));
                ITimeRange recordingRange = loader.getRecordingRange();
                System.gc();
                Runtime runtime = Runtime.getRuntime();
                long availableMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
                double loadQuota = (double)availableMemory / ((double)file.length() * memoryToFileSizeRatio);
                flightRecording = this.doCreateRecordingInner(loader, recordingRange, loadQuota, monitor);
            }
            catch (Exception e) {
                block7: {
                    if (FlightRecordingEditor.causedByOom(e) && !(memoryToFileSizeRatio > 10.0)) break block7;
                    throw e;
                }
                IOToolkit.closeSilently((Closeable)loader);
            }
            catch (OutOfMemoryError oom) {
                block8: {
                    if (!(memoryToFileSizeRatio > 10.0)) break block8;
                    throw oom;
                    {
                        catch (Throwable throwable) {
                            IOToolkit.closeSilently(loader);
                            throw throwable;
                        }
                    }
                }
                IOToolkit.closeSilently((Closeable)loader);
            }
            IOToolkit.closeSilently((Closeable)loader);
            return flightRecording;
            memoryToFileSizeRatio += 1.0;
        }
    }

    private static boolean causedByOom(Throwable th) {
        if (th.getCause() != null) {
            return FlightRecordingEditor.causedByOom(th.getCause());
        }
        return th instanceof OutOfMemoryError;
    }

    private FlightRecording doCreateRecordingInner(FlightRecordingLoader loader, ITimeRange recordingRange, double loadQuota, IProgressMonitor monitor) throws Exception {
        if (loadQuota < 1.0) {
            ITimeRange newRange = this.selectRangeWizard(loadQuota, recordingRange);
            if (newRange != null) {
                return loader.load(newRange);
            }
            monitor.setCanceled(true);
            throw new OperationCanceledException();
        }
        return loader.load();
    }

    private File handleZippedFile(File file, IProgressMonitor monitor) throws IOException {
        if (IOToolkit.isGZipFile((File)file) || IOToolkit.isZipFile((File)file)) {
            return this.unzipFile(file, monitor);
        }
        return file;
    }

    private File unzipFile(File file, IProgressMonitor monitor) throws IOException {
        File unzippedFile = new File(FlightRecordingEditor.getUnzippedName(file.getPath()));
        if (unzippedFile.exists() && unzippedFile.lastModified() > file.lastModified()) {
            return unzippedFile;
        }
        boolean acceptUnzip = DialogToolkit.openQuestionOnUiThread((String)Messages.FILE_OPENER_ZIPPED_FILE_TITLE, (String)MessageFormat.format(Messages.FILE_OPENER_ZIPPED_FILE_TEXT, file.getName()));
        if (acceptUnzip) {
            InflaterInputStream is = null;
            FileOutputStream os = null;
            try {
                int bytesRead;
                is = IOToolkit.isGZipFile((File)file) ? new GZIPInputStream(new FileInputStream(file)) : new ZipInputStream(new FileInputStream(file));
                os = new FileOutputStream(unzippedFile, false);
                byte[] buffer = new byte[16384];
                do {
                    if ((bytesRead = ((InputStream)is).read(buffer)) == -1) continue;
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                } while (bytesRead != -1);
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                IOToolkit.closeSilently(os);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
            IOToolkit.closeSilently((Closeable)os);
            return unzippedFile;
        }
        monitor.setCanceled(true);
        throw new OperationCanceledException();
    }

    private static String getUnzippedName(String name) {
        int dot = name.lastIndexOf(46);
        return String.valueOf(name.substring(0, dot)) + ".unzipped" + name.substring(dot);
    }

    private void checkForLostEvents(FlightRecording recording) {
        IView v = recording.createView();
        for (IEventType type : recording.getEventTypes()) {
            if (!"recordings/buffer_lost".equals(type.getPath())) continue;
            v.setEventTypes(Arrays.asList(type));
            if (v.iterator().hasNext()) {
                this.showLostEventsErrorMessage();
            }
            return;
        }
    }

    private void showLostEventsErrorMessage() {
        int i = 0;
        while (i < this.pages.size()) {
            IMessageManager manager = (IMessageManager)((IFormPage)this.pages.get(i)).getAdapter(IMessageManager.class);
            if (manager != null) {
                TemporaryMessage message = new TemporaryMessage(Messages.EDITOR_ERROR_LOST_BUFFER_TEXT, 3);
                message.setDelay(Integer.MAX_VALUE);
                message.show(manager, this.getSite().getShell().getDisplay());
            }
            ++i;
        }
    }

    private static class ComponentVerifier
    implements IComponentVerifier {
        private List<String> enabledEventTypes = new ArrayList<String>();

        ComponentVerifier(FlightRecording recording) {
            IView view = recording.createView();
            for (IEventType type : recording.getEventTypes()) {
                if (!"recordings/recording_setting".equals(type.getPath())) continue;
                view.setEventTypes(Arrays.asList(type));
                for (IEvent e : view) {
                    if (!((Boolean)e.getValue("enabled")).booleanValue()) continue;
                    Object path = e.getValue("path");
                    if (path == null) {
                        return;
                    }
                    this.enabledEventTypes.add(path.toString());
                }
                return;
            }
        }

        public String getErrorMessage(Object component) {
            if (component instanceof ITypeVisibilitySupport) {
                EventTypeDescriptorRepository repo = ((ITypeVisibilitySupport)component).getEventTypeDescriptorRepository();
                HashSet<String> disabledEventTypeNames = new HashSet<String>();
                for (EventTypeDescriptor type : repo.getDescriptors()) {
                    for (String eventType : this.enabledEventTypes) {
                        if (!type.accepts(eventType)) continue;
                        return null;
                    }
                    disabledEventTypeNames.add(type.getName());
                }
                if (disabledEventTypeNames.size() == 1) {
                    return NLS.bind((String)Messages.EDITOR_ERROR_EVENT_TYPE_DISABLED_TEXT, (Object)("'" + (String)disabledEventTypeNames.iterator().next() + "'"));
                }
                StringBuilder events = new StringBuilder();
                Iterator it = disabledEventTypeNames.iterator();
                while (it.hasNext()) {
                    events.append("'").append((String)it.next()).append("'").append(it.hasNext() ? " " : "");
                }
                return NLS.bind((String)Messages.EDITOR_ERROR_EVENT_TYPES_DISABLED_TEXT, (Object)events.toString());
            }
            return null;
        }
    }
}

