/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.adaptivefolders;

import com.jrockit.mc.components.ui.SetData;
import com.jrockit.mc.components.ui.base.AbstractUIContainer;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.adaptive.AdaptiveModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.adaptive.AdaptiveModelItem;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class AdaptiveFoldersComponent
extends AbstractUIContainer
implements IEventConsumer {
    private AdaptiveModelBuilder builder;
    private List<Control> controls = new ArrayList<Control>();
    private CTabFolder tabFolder;
    private List<Boolean> lastShowList = null;

    public Control createPart(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0);
        this.addInitialTabs();
        this.getFormToolkit().adapt((Composite)this.tabFolder);
        this.tabFolder.setSelection(0);
        this.builder = new AdaptiveModelBuilder(this.getServiceLocator(), this.getComponentDescriptor());
        return this.tabFolder;
    }

    private void addInitialTabs() {
        GUIFactory factory = GUIFactory.createChildFactory((IServiceLocator)this.getServiceLocator());
        for (LayoutItem tfid : this.getLayoutItem().getChildren()) {
            ComponentDescriptor cd = tfid.getComponentDescriptor();
            if (cd == null) continue;
            ComponentHolder ch = factory.createDisposableComponent(tfid, (Composite)this.tabFolder);
            if (ch.control == null) continue;
            this.createTabItem(ch.control, cd);
            factory.addComponentToScope(ch.component);
            this.controls.add(ch.control);
        }
    }

    private void createTabItem(Control control, ComponentDescriptor cd) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setControl(control);
        tabItem.setText(cd.getName());
        SetData.set((Widget)tabItem, (ComponentDescriptor)cd, (String)"tab");
    }

    private void rebuildTabFolder(List<Boolean> showList) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            tab.dispose();
            ++n2;
        }
        int index = 0;
        boolean shown = false;
        for (Boolean show : showList) {
            if (show.booleanValue()) {
                this.createTabItem(this.controls.get(index), ((LayoutItem)this.getLayoutItem().getChildren().get(index)).getComponentDescriptor());
                shown = true;
            }
            ++index;
        }
        if (!shown) {
            int i = 0;
            while (i < showList.size()) {
                this.createTabItem(this.controls.get(i), ((LayoutItem)this.getLayoutItem().getChildren().get(i)).getComponentDescriptor());
                ++i;
            }
        }
    }

    public void initializeUI() {
        this.builder.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AdaptiveFoldersComponent.this.showInUIThread();
            }
        });
    }

    protected void refresh() {
        this.builder.scheduleRebuild();
    }

    private void setSelection(String selected) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getText().equals(selected)) {
                this.tabFolder.setSelection(tab);
                return;
            }
            ++n2;
        }
        this.tabFolder.setSelection(0);
    }

    private void showInUIThread() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                List showList = (List)AdaptiveFoldersComponent.this.builder.getModel();
                if (!showList.equals(AdaptiveFoldersComponent.this.lastShowList)) {
                    CTabItem selection = AdaptiveFoldersComponent.this.tabFolder.getSelection();
                    String selected = null;
                    if (selection != null) {
                        selected = selection.getText();
                    }
                    AdaptiveFoldersComponent.this.rebuildTabFolder(showList);
                    AdaptiveFoldersComponent.this.getFormToolkit().adapt((Composite)AdaptiveFoldersComponent.this.tabFolder);
                    AdaptiveFoldersComponent.this.setSelection(selected);
                    AdaptiveFoldersComponent.this.tabFolder.layout(true, true);
                    AdaptiveFoldersComponent.this.lastShowList = showList;
                }
            }
        });
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events, Role Source) {
        if (Source.equals((Object)Role.MASTER)) {
            LinkedList<AdaptiveModelItem> items = new LinkedList<AdaptiveModelItem>();
            for (ITypeVisibilitySupport v : this.getComponents().getAllComponents(ITypeVisibilitySupport.class)) {
                EventTypeDescriptorRepository repo = v.getEventTypeDescriptorRepository();
                EventTypeAcceptor acceptor = new EventTypeAcceptor(this.getServiceLocator(), repo);
                AdaptiveModelItem smi = new AdaptiveModelItem(acceptor.getAcceptedSet());
                items.add(smi);
            }
            this.builder.setModelItems(items);
            this.builder.setEventView(new SimpleView(events));
            this.markDirty();
        }
    }
}

