/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.IRangeListener;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ChartViewer<T> {
    private final ListenerList m_rangeListeners = new ListenerList();
    private final ChartModelBuilder<T> m_imageBuilder;
    private final Composite m_control;

    public ChartViewer(ChartModelBuilder<T> modelBuilder, Composite parent, FormToolkit toolkit) {
        this.m_imageBuilder = modelBuilder;
        this.m_control = this.createControl(parent, toolkit);
        this.hookModelView();
    }

    protected abstract Composite createControl(Composite var1, FormToolkit var2);

    public abstract void refresh();

    public void setRange(long startTime, long endTime) {
        long duration = endTime - startTime;
        if (duration > 0L) {
            this.getModelBuilder().setRange((ITimeRange)new TimeRange(startTime, endTime));
        }
    }

    protected final void updateInUIThread(final T model) {
        DisplayToolkit.safeAsyncExec((Widget)this.m_control, (Runnable)new Runnable(){

            @Override
            public void run() {
                ChartViewer.this.refreshGraphics(model);
            }
        });
    }

    protected abstract void refreshGraphics(T var1);

    private void hookModelView() {
        this.getModelBuilder().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (o instanceof ChartModelBuilder) {
                    ChartViewer.this.updateInUIThread(((ChartModelBuilder)o).getModel());
                }
            }
        });
    }

    protected final ChartModelBuilder<T> getModelBuilder() {
        return this.m_imageBuilder;
    }

    protected final void fireRangeChange(Number start, Number end) {
        Object[] objectArray = this.m_rangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((IRangeListener)object).onRangeChange(start, end);
            ++n2;
        }
    }

    public final void addRangeListener(IRangeListener listener) {
        this.m_rangeListeners.add((Object)listener);
    }

    public final void removeRangeListener(IRangeListener listener) {
        this.m_rangeListeners.remove((Object)listener);
    }

    public final Composite getControl() {
        return this.m_control;
    }
}

