/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.image;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageModel;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.eclipse.core.runtime.IProgressMonitor;
import se.hirt.greychart.FontAndColors;
import se.hirt.greychart.SelectionRenderer;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.DefaultXYGreyChart;

public class ChartImageBuilder
extends ChartModelBuilder<ChartImageModel> {
    public ChartImageBuilder(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, String name) {
        super(serviceLocator, chartDescriptor, name);
    }

    @Override
    protected ChartImageModel buildModel(IView view, IProgressMonitor monitor) {
        Point size = this.getSize();
        ITimeRange tr = this.getRange();
        BufferedImage result = new BufferedImage(size.x, size.y, 5);
        Rectangle r = new Rectangle(0, 0, size.x, size.y);
        Graphics2D g = result.createGraphics();
        SelectionRenderer sd = tr != null ? this.drawChart(g, r, tr) : this.drawEmpty(g, r);
        return new ChartImageModel(result, sd);
    }

    protected SelectionRenderer drawEmpty(Graphics2D g, Rectangle r) {
        g.setBackground(FontAndColors.getDefaultBackground());
        g.setColor(FontAndColors.getDefaultBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
        return null;
    }

    private SelectionRenderer drawChart(Graphics2D g, Rectangle r, ITimeRange tr) {
        FLRChartDescriptor chartDescriptor = this.createLocalChartDescriptor();
        if (!this.hasTimeStampXAxis(chartDescriptor)) {
            tr = this.findRange(this.getRange(), chartDescriptor);
        }
        DefaultXYGreyChart<ITimestampedData> renderChart = this.createNewCharto(chartDescriptor, tr);
        try {
            renderChart.render(g, r);
            if (this.getAllowChartSelection(chartDescriptor)) {
                return renderChart.createSelectionRenderer();
            }
            return null;
        }
        catch (RuntimeException re) {
            return this.drawEmpty(g, r);
        }
    }
}

