/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.image;

import com.jrockit.mc.flightrecorder.ui.components.chart.ChartViewer;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageModel;
import com.jrockit.mc.flightrecorder.ui.components.range.ProgressComponent;
import com.jrockit.mc.greychart.ui.views.ChartCanvas;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.SelectionRenderer;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.data.SeriesProvider;

public final class ChartImageViewer
extends ChartViewer<ChartImageModel> {
    private ProgressComponent m_panel;
    private final SeriesProvider<IXYData<Long, Double>> m_provider = new SeriesProvider();

    public ChartImageViewer(Composite parent, FormToolkit toolkit, ChartImageBuilder builder) {
        super(builder, parent, toolkit);
        this.hookSelectionListener();
    }

    private ProgressComponent createProgressPanel() {
        MCColor c = new MCColor(UIPlugin.getDefault().getFontColorToolkit().getDefaultBackgroundColor().getRGB());
        ProgressComponent pc = new ProgressComponent();
        pc.setBackground(c.getAWTColor());
        return pc;
    }

    private void hookSelectionListener() {
        this.getChartCanvas().getSelection().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SelectionRenderer sd;
                if (ChartImageViewer.this.getChartCanvas().getSelection().isFinished() && (sd = ChartImageViewer.this.getChartCanvas().getSelectionRenderer()) != null && sd.hasValidSelection() && sd.getSelectedEndX().longValue() - sd.getSelectedStartX().longValue() > 2L) {
                    ChartImageViewer.this.setRange(sd.getSelectedStartX().longValue(), sd.getSelectedEndX().longValue());
                    ChartImageViewer.this.fireRangeChange(sd.getSelectedStartX(), sd.getSelectedEndX());
                    ChartImageViewer.this.refresh();
                }
            }
        });
    }

    private ChartCanvas getChartCanvas() {
        return (ChartCanvas)this.getControl();
    }

    public SeriesProvider<IXYData<Long, Double>> getDataProvider() {
        return this.m_provider;
    }

    @Override
    protected Composite createControl(Composite parent, FormToolkit toolkitm) {
        this.m_panel = this.createProgressPanel();
        ChartCanvas chartCanvas = new ChartCanvas(parent, (JComponent)this.m_panel);
        chartCanvas.setLayout((Layout)new FillLayout());
        this.hookResizeListener((Canvas)chartCanvas);
        return chartCanvas;
    }

    private void hookResizeListener(final Canvas canvas) {
        canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = canvas.getClientArea().width;
                int height = canvas.getClientArea().height;
                ChartImageViewer.this.getModelBuilder().setSize(width, height);
                ChartImageViewer.this.getModelBuilder().scheduleRebuild();
            }
        });
    }

    @Override
    public void refresh() {
        if (!this.getChartCanvas().isDisposed()) {
            if (!this.getModelBuilder().rebuildAWT() && !this.m_panel.isInProgress()) {
                this.m_panel.setInProgress(true);
                this.scheduleProgress();
            }
            this.redrawCanvas();
        }
    }

    private void redrawCanvas() {
        this.getChartCanvas().redraw();
    }

    private void scheduleProgress() {
        DisplayToolkit.safeTimerExec((Widget)this.getChartCanvas(), (int)100, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChartImageViewer.this.m_panel.isInProgress()) {
                    ChartImageViewer.this.redrawCanvas();
                    ChartImageViewer.this.scheduleProgress();
                }
            }
        });
    }

    @Override
    protected void refreshGraphics(ChartImageModel imageModel) {
        if (!this.getChartCanvas().isDisposed()) {
            this.m_panel.setNewImage(imageModel.getImage());
            this.m_panel.setInProgress(false);
            this.getChartCanvas().setSelectionRenderer(imageModel.getSelectionRenderer());
            this.redrawCanvas();
        }
    }
}

