/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import se.hirt.greychart.data.DefaultTimestampedData;
import se.hirt.greychart.data.ITimestampedData;

public class BarFLRIterator
implements Iterator<ITimestampedData> {
    private final Iterator<IEvent> iterator;
    private final String yIdentifier;
    private IEventType lastType;
    private Queue<ITimestampedData> pointQueue = new ArrayDeque<ITimestampedData>();
    private IEvent currentEvent;

    public BarFLRIterator(Iterator<IEvent> iterator, String yIdentifier) {
        this.iterator = iterator;
        this.yIdentifier = yIdentifier;
        this.skipForward();
    }

    @Override
    public boolean hasNext() {
        return this.currentEvent != null || !this.pointQueue.isEmpty();
    }

    @Override
    public ITimestampedData next() {
        if (this.pointQueue.isEmpty()) {
            RangeNode head;
            RangeNode start = head = new RangeNode(this.currentEvent.getStartTimestamp(), this.currentEvent.getEndTimestamp(), this.getValue(this.currentEvent));
            long lastTimestamp = this.currentEvent.getEndTimestamp();
            this.skipForward();
            while (this.currentEvent != null && this.currentEvent.getStartTimestamp() <= lastTimestamp) {
                start = this.stepTo(start, this.currentEvent.getStartTimestamp());
                this.addRange(start, this.currentEvent.getStartTimestamp(), this.currentEvent.getEndTimestamp(), this.getValue(this.currentEvent));
                lastTimestamp = Math.max(lastTimestamp, this.currentEvent.getEndTimestamp());
                this.skipForward();
            }
            this.pushPoints(head);
        }
        return this.pointQueue.remove();
    }

    private void pushPoints(RangeNode node) {
        double lastValue = 0.0;
        while (node.getNext() != null) {
            double value = node.getValue();
            if (value != lastValue) {
                this.pushPoint(node.getStartTime(), lastValue);
                this.pushPoint(node.getStartTime(), value);
                lastValue = value;
            }
            node = node.getNext();
        }
        this.pushPoint(node.getStartTime(), lastValue);
        this.pushPoint(node.getStartTime(), node.getValue());
        this.pushPoint(node.getEndTime(), node.getValue());
        this.pushPoint(node.getEndTime(), 0.0);
    }

    private void pushPoint(long startTimestamp, double value) {
        this.pointQueue.add((ITimestampedData)new DefaultTimestampedData(Long.valueOf(startTimestamp), (Number)value));
    }

    private void addRange(RangeNode node, long startTimestamp, long endTimestamp, double value) {
        while (startTimestamp < endTimestamp) {
            if (node.getEndTime() > startTimestamp) {
                if (node.getValue() >= value) {
                    startTimestamp = node.getEndTime();
                    continue;
                }
                if (node.getStartTime() < startTimestamp) {
                    node = this.splitRange(node, startTimestamp, node.getValue());
                    continue;
                }
                if (node.getEndTime() <= endTimestamp) {
                    node.setValue(value);
                    startTimestamp = node.getEndTime();
                    continue;
                }
                this.splitRange(node, endTimestamp, value);
                return;
            }
            if (node.getNext() == null) {
                if (node.getValue() == value) {
                    node.setRange(node.getStartTime(), endTimestamp);
                } else {
                    RangeNode newNode = new RangeNode(startTimestamp, endTimestamp, value);
                    node.setNext(newNode);
                }
                return;
            }
            node = node.getNext();
        }
    }

    private RangeNode splitRange(RangeNode node, long splitTimestamp, double newNodeValue) {
        RangeNode newNode = new RangeNode(splitTimestamp, node.getEndTime(), node.getValue());
        newNode.setNext(node.getNext());
        node.setRange(node.getStartTime(), splitTimestamp);
        node.setNext(newNode);
        node.setValue(newNodeValue);
        return node;
    }

    private RangeNode stepTo(RangeNode prevNode, long startTimestamp) {
        while (prevNode.getNext() != null && prevNode.getNext().getEndTime() <= startTimestamp) {
            prevNode = prevNode.getNext();
        }
        return prevNode;
    }

    private double getValue(IEvent event) {
        if (event == null) {
            return 0.0;
        }
        Number val = (Number)this.lastType.getField(this.yIdentifier).getValue(event);
        if (val == null) {
            return 0.0;
        }
        return val.doubleValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove events from the model!");
    }

    private static boolean isValid(IField fieldStart, IField fieldEnd, IField fieldY) {
        return fieldY != null && fieldEnd != null && fieldStart != null;
    }

    private void skipForward() {
        while (this.iterator.hasNext()) {
            IEvent event = this.iterator.next();
            IEventType type = event.getEventType();
            if (type != this.lastType) {
                this.lastType = type;
            }
            if (!BarFLRIterator.isValid(type.getField("(startTime)"), type.getField("(endTime)"), type.getField(this.yIdentifier))) continue;
            this.currentEvent = event;
            return;
        }
        this.currentEvent = null;
    }

    private static class RangeNode {
        private RangeNode next;
        private long startTime;
        private long endTime;
        private double value;

        public RangeNode(long startTime, long endTime, double value) {
            this.setRange(startTime, endTime);
            this.setValue(value);
        }

        public RangeNode getNext() {
            return this.next;
        }

        public void setNext(RangeNode newNext) {
            this.next = newNext;
        }

        public void setRange(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public String toString() {
            String s = "{" + this.startTime + "->" + this.endTime + '@' + this.value + '}';
            if (this.next != null) {
                s = String.valueOf(s) + " -> " + this.next.toString();
            }
            return s;
        }
    }
}

