/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.flightrecorder.provider.ConstantField;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDataSeries;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.hirt.greychart.data.DefaultTimestampedData;
import se.hirt.greychart.data.ITimestampedData;

public final class FilteredFLRIterator
implements Iterator<ITimestampedData> {
    private final Iterator<IEvent> m_iterator;
    private final String m_xIdentifier;
    private final String m_yIdentifier;
    private final Map<IEventType, DataPairLookup> m_typeInfo = new HashMap<IEventType, DataPairLookup>();
    private IEventType m_lastType;
    private ITimestampedData m_next;
    private DataPairLookup m_typeInformation;

    public FilteredFLRIterator(Iterator<IEvent> iterator, String xIdentifier, String yIdentifier) {
        this.m_iterator = iterator;
        this.m_xIdentifier = xIdentifier;
        this.m_yIdentifier = yIdentifier;
        this.skipForward();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public ITimestampedData next() {
        ITimestampedData next = this.m_next;
        this.skipForward();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove event");
    }

    private void skipForward() {
        while (this.m_iterator.hasNext()) {
            IEvent event = this.m_iterator.next();
            IEventType type = event.getEventType();
            if (type != this.m_lastType) {
                this.m_typeInformation = this.m_typeInfo.get(type);
                if (this.m_typeInformation == null) {
                    ConstantField xField = this.m_xIdentifier == FLRDataSeries.ZERO_FIELD.getIdentifier() ? FLRDataSeries.ZERO_FIELD : type.getField(this.m_xIdentifier);
                    IField yField = type.getField(this.m_yIdentifier);
                    this.m_typeInformation = new DataPairLookup((IField)xField, yField, xField != null && yField != null);
                    this.m_typeInfo.put(type, this.m_typeInformation);
                }
                this.m_lastType = type;
            }
            if (!this.m_typeInformation.valid) continue;
            Number xValue = this.m_typeInformation.getX(event);
            Number yValue = this.m_typeInformation.getY(event);
            if (yValue == null || !(xValue instanceof Long)) continue;
            this.m_next = new DefaultTimestampedData(Long.valueOf(xValue.longValue()), yValue);
            return;
        }
        this.m_next = null;
    }

    private static final class DataPairLookup {
        private final IField yField;
        private final IField xField;
        private final boolean valid;

        public DataPairLookup(IField xField, IField yField, boolean valid) {
            this.xField = xField;
            this.yField = yField;
            this.valid = valid;
        }

        public Number getX(IEvent event) {
            return (Number)this.xField.getValue(event);
        }

        public Number getY(IEvent event) {
            return (Number)this.yField.getValue(event);
        }
    }
}

