/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.table;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableModel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;

public class ChartTableBuilder
extends ChartModelBuilder<ChartTableModel> {
    private static final int CANCEL_CHECK_EVERY_X = 10000;
    private static final int MAX_TABLE_ROWS = 100000;

    public ChartTableBuilder(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, String name) {
        super(serviceLocator, chartDescriptor, name);
    }

    @Override
    protected ChartTableModel buildModel(IView view, IProgressMonitor monitor) {
        Point size = this.getSize();
        ITimeRange rnage = this.getRange();
        BufferedImage result = new BufferedImage(size.x, size.y, 5);
        Rectangle r = new Rectangle(0, 0, size.x, size.y);
        Graphics2D g = result.createGraphics();
        ChartTableModel model = new ChartTableModel();
        if (rnage != null) {
            FLRChartDescriptor chartDescriptor = this.createLocalChartDescriptor();
            if (!this.hasTimeStampXAxis(chartDescriptor)) {
                rnage = this.findRange(this.getRange(), chartDescriptor);
            }
            DefaultXYGreyChart<ITimestampedData> chart = this.drawChart(g, r, rnage);
            view.setRange(rnage);
            view.setExpansion(Expansion.NORMAL);
            int index = 0;
            DefaultDataSeriesDescriptor[] defaultDataSeriesDescriptorArray = chart.getDescriptors();
            int n = defaultDataSeriesDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultDataSeriesDescriptor dsd = defaultDataSeriesDescriptorArray[n2];
                model.add(index, this.createList(monitor, (DataSeries<ITimestampedData>)chart.getDataSeries((DataSeriesDescriptor)dsd), rnage));
                ++index;
                ++n2;
            }
        }
        return model;
    }

    private List<ITimestampedData> createList(IProgressMonitor monitor, DataSeries<ITimestampedData> ds, ITimeRange tr) {
        ArrayList<ITimestampedData> values = new ArrayList<ITimestampedData>();
        Iterator it = ds.createIterator(tr.getStartTimestamp(), tr.getEndTimestamp());
        int counter = 0;
        while (it.hasNext()) {
            values.add((ITimestampedData)it.next());
            if (counter++ % 10000 == 0 && monitor.isCanceled()) {
                return values;
            }
            if (counter != 100000) continue;
            this.setLastBuildMessage("Too many events to fit table. Will only show the first 100000");
            return values;
        }
        return values;
    }

    private DefaultXYGreyChart<ITimestampedData> drawChart(Graphics2D g, Rectangle r, ITimeRange tr) {
        FLRChartDescriptor chartDescriptor = this.createLocalChartDescriptor();
        if (!this.hasTimeStampXAxis(chartDescriptor)) {
            tr = this.findRange(this.getRange(), chartDescriptor);
        }
        DefaultXYGreyChart<ITimestampedData> renderChart = this.createNewCharto(chartDescriptor, tr);
        try {
            renderChart.render(g, r);
        }
        catch (RuntimeException re) {
            return null;
        }
        return renderChart;
    }
}

