/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.table;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartViewer;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableModel;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.DataSeriesField;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.DataValueProvider;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.SimpleDataSeriesProvider;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.AxisDescriptor;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.MultiField;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChartTableViewer
extends ChartViewer<ChartTableModel> {
    private static Field[] FIELD_PROTOTYPES = new Field[]{DataValueProvider.FIELD_X, DataValueProvider.FIELD_Y};
    private final Composite m_container;
    private final Map<ContentType, Field> m_contentTypeMapping = new LinkedHashMap<ContentType, Field>();
    private final ChartDescriptor m_chartDescriptor;
    private ComboViewer m_comboViewer;
    private FieldTableViewer m_tableViewer;

    public ChartTableViewer(Composite parent, FormToolkit formToolkit, ChartTableBuilder builder, ChartDescriptor chartDescriptor) {
        super(builder, parent, formToolkit);
        this.initializeFieldContentTypeMapping();
        this.m_container = formToolkit.createComposite(parent);
        this.m_chartDescriptor = chartDescriptor;
        this.m_container.setLayout((Layout)new GridLayout(2, false));
        this.m_container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        this.m_comboViewer.setInput((Object)chartDescriptor);
        this.m_comboViewer.refresh();
        if (!chartDescriptor.getDataSeriesDescriptors().isEmpty()) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection(chartDescriptor.getDataSeriesDescriptors().get(0)), true);
        }
        UnitDescriptor unitDescriptor = new UnitDescriptor();
        unitDescriptor.setDisplayUnit((DisplayUnit)UnitLookup.TIMESTAMP.getDisplayUnits().get(0));
        this.getChartDescriptor().getXAxis().setUnit(unitDescriptor);
    }

    void initializeFieldContentTypeMapping() {
        this.m_contentTypeMapping.put(UnitLookup.MEMORY, DataSeriesField.BYTE_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.TIMESTAMP, DataSeriesField.TIME_STAMP_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.PERCENTAGE, DataSeriesField.PERCENTAGE_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.TIMESPAN, DataSeriesField.TIME_SPAN_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.COUNT, DataSeriesField.NUMBERFIELD_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.ADDRESS, DataSeriesField.NUMBERFIELD_FIELD);
    }

    @Override
    protected Composite createControl(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        Label label = toolkit.createLabel(container, Messages.ACCESSIBLE_CHART_VIEWER_DATASERIES_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.m_comboViewer = this.createComboViewer(container, toolkit);
        this.m_comboViewer.getControl().setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.m_tableViewer = this.createTableViewer(container, toolkit);
        this.m_tableViewer.getControl().setLayoutData((Object)gd3);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(container);
        return container;
    }

    private ChartDescriptor getChartDescriptor() {
        return this.m_chartDescriptor;
    }

    private ComboViewer createComboViewer(Composite parent, FormToolkit toolkit) {
        Combo combo = new Combo(parent, 65544);
        combo.setVisibleItemCount(15);
        toolkit.adapt((Composite)combo);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setContentProvider((IContentProvider)new SimpleDataSeriesProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider(this.getChartDescriptor(), parent.getDisplay(), 12));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    ChartTableViewer.this.selectDataSeries((DataSeriesDescriptor)ss.getFirstElement());
                }
            }
        });
        return viewer;
    }

    private void selectDataSeries(DataSeriesDescriptor selected) {
        int index = this.getChartDescriptor().getDataSeriesDescriptors().indexOf(selected);
        this.getDataValueProvider().setSelectedDataSeries(index);
        this.setupFields(selected);
        this.m_tableViewer.refresh();
    }

    private DataValueProvider getDataValueProvider() {
        return (DataValueProvider)this.m_tableViewer.getContentProvider();
    }

    private void setupFields(DataSeriesDescriptor dsd) {
        YAxisDescriptor yaAxisDescriptor = this.getAxisFromIndex(dsd);
        String name = dsd.getName();
        this.updateField(this.getYField(), (AxisDescriptor)yaAxisDescriptor, name);
        this.updateField(this.getXField(), (AxisDescriptor)this.getChartDescriptor().getXAxis(), "Time");
        this.m_tableViewer.refreshLayout(true);
    }

    private YAxisDescriptor getAxisFromIndex(DataSeriesDescriptor dsd) {
        if (this.getChartDescriptor().getLeftYAxis().getDataSeries().contains(dsd)) {
            return this.getChartDescriptor().getLeftYAxis();
        }
        return this.getChartDescriptor().getRightYAxis();
    }

    private MultiField getYField() {
        return (MultiField)this.m_tableViewer.getFields()[1];
    }

    private MultiField getXField() {
        return (MultiField)this.m_tableViewer.getFields()[0];
    }

    private void updateField(MultiField field, AxisDescriptor axisDescriptor, String name) {
        UnitDescriptor unit = axisDescriptor.getUnit();
        ContentType ct = unit.getDisplayUnit().getContentType();
        field.selectField(this.lookupField(ct));
        field.setName(name);
    }

    private Field lookupField(ContentType ct) {
        Field field = this.m_contentTypeMapping.get(ct);
        return field == null ? DataSeriesField.NUMBERFIELD_FIELD : field;
    }

    private FieldTableViewer createTableViewer(Composite parent, FormToolkit formToolkit) {
        Table table = formToolkit.createTable(parent, 268501762);
        FieldTableViewer viewer = new FieldTableViewer(table, FieldToolkit.instantiateFieldArray((Field[])FIELD_PROTOTYPES));
        viewer.setContentProvider((IContentProvider)new DataValueProvider());
        return viewer;
    }

    @Override
    public void refresh() {
        this.getModelBuilder().scheduleRebuild();
    }

    @Override
    public void setRange(long startTime, long endTime) {
        this.getModelBuilder().setRange((ITimeRange)new TimeRange(startTime, endTime));
        this.refresh();
    }

    @Override
    protected void refreshGraphics(ChartTableModel imageModel) {
        if (this.m_tableViewer != null && !this.m_tableViewer.getControl().isDisposed()) {
            this.m_tableViewer.setInput((Object)imageModel);
        }
    }
}

