/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.ISortedAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.column.FieldExtractor;
import com.jrockit.mc.flightrecorder.ui.components.column.Gatherer;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GathererFactory {
    private final AggregatorDescriptor[] m_aggregatorDescriptors;
    private final Map<IEventType, RetriverHolder> m_attributeMapping;

    public GathererFactory(IServiceLocator serviceLocator, HistogramColumnDescriptorRepository repository) {
        this.m_aggregatorDescriptors = this.createAggregators(repository);
        this.m_attributeMapping = this.createAttributeMapping(serviceLocator, repository);
    }

    public RetriverHolder getRetrivers(IEventType eventType) {
        return this.m_attributeMapping.get(eventType);
    }

    private Map<IEventType, RetriverHolder> createAttributeMapping(IServiceLocator locator, HistogramColumnDescriptorRepository repository) {
        EventTypeAcceptor eta = new EventTypeAcceptor(locator, repository.getEventTypeDescriptorRepository());
        List<String> attributes = this.createAttributes(repository);
        attributes.add(repository.getGroupColumn().getAttributeIdentifier());
        HashMap<IEventType, RetriverHolder> attributeIndexMapping = new HashMap<IEventType, RetriverHolder>();
        for (IEventType type : eta.getAcceptedSet()) {
            attributeIndexMapping.put(type, this.createAttributeMapping(type, attributes, repository.getGroupByAttribute()));
        }
        return attributeIndexMapping;
    }

    private List<String> createAttributes(ColumnDescriptorRepository repository) {
        ArrayList<String> attributeIdentifiers = new ArrayList<String>();
        for (ColumnDescriptor cd : repository.getColumnDescriptors()) {
            attributeIdentifiers.add(cd.getAttributeIdentifier());
        }
        return attributeIdentifiers;
    }

    private AggregatorDescriptor[] createAggregators(ColumnDescriptorRepository repository) {
        ArrayList<AggregatorDescriptor> ads = new ArrayList<AggregatorDescriptor>();
        for (ColumnDescriptor cd : repository.getColumnDescriptors()) {
            ads.add(AggregatorFactory.createAggregatorDescriptor(cd.getAggregatorIdentifier()));
        }
        return ads.toArray(new AggregatorDescriptor[ads.size()]);
    }

    private RetriverHolder createAttributeMapping(IEventType type, List<String> attribruteIdentifiers, String groupAttribute) {
        IField[] retrievers = new IField[attribruteIdentifiers.size()];
        int index = 0;
        for (String attributeIdentifier : attribruteIdentifiers) {
            retrievers[index++] = FieldExtractor.lookupRetriever(type, attributeIdentifier);
        }
        return new RetriverHolder(retrievers, type.getField(groupAttribute));
    }

    public Gatherer createGather() {
        IAggregator[] aggregators = new IAggregator[this.m_aggregatorDescriptors.length];
        int n = 0;
        while (n < aggregators.length) {
            aggregators[n] = AggregatorFactory.createAggregator(this.m_aggregatorDescriptors[n]);
            ++n;
        }
        return new Gatherer(aggregators);
    }

    public boolean needsSortedValues() {
        int n = 0;
        while (n < this.m_aggregatorDescriptors.length) {
            if (ISortedAggregator.class.isAssignableFrom(this.m_aggregatorDescriptors[n].getAggregatorClass())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

