/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.custom;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.util.CombinedIterable;
import com.jrockit.mc.components.ui.util.ImageDescriptorImageProvider;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.custom.CustomBuilder;
import com.jrockit.mc.flightrecorder.ui.components.custom.CustomLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableProviderRepository;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventRow;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventRowContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.table.AbstractTableViewerComponent;
import com.jrockit.mc.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;

public final class CustomTableViewerComponent
extends AbstractTableViewerComponent {
    @Override
    protected ViewModelBuilder<IEventRow[]> createModelBuilder() {
        return new CustomBuilder(this.getServiceLocator(), this.getEventTableDescriptor());
    }

    @Override
    protected IContentProvider createContentProvider(ColumnDescriptorRepository repository) {
        return new IEventRowContentProvider();
    }

    @Override
    protected FieldLabelProvider createLabelProvider(Display display) {
        if (this.getRepository().hasImage()) {
            return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new ImageDescriptorImageProvider(display, this.getRepository().getImageDescriptor()));
        }
        return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new CustomLabelProvider());
    }

    @Override
    protected Iterable<IEvent> createSelectionIterator(IStructuredSelection selection) {
        ArrayList<IEventRow> iterables = new ArrayList<IEventRow>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            iterables.add((IEventRow)it.next());
        }
        return new CombinedIterable(iterables);
    }

    @Override
    protected void hookSelectionListener(FieldTableViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OperativeSetService oss = (OperativeSetService)CustomTableViewerComponent.this.getServiceLocator().getService(OperativeSetService.class);
                oss.setSelectedRange(CustomTableViewerComponent.this.getModelBuilder().getView().getRange());
                oss.setEventFactory(CustomTableViewerComponent.this.createSelectionIterator((IStructuredSelection)event.getSelection()));
                CustomTableViewerComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    private EventTableDescriptor getEventTableDescriptor() {
        String dataProvider = (String)PersistenceToolkit.getSetting((Object)this.getRepository()).getChildObject("dataProvider", String.class);
        return EventTableProviderRepository.findEventTableDescriptor(dataProvider);
    }
}

