/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.eventtable;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

final class TableModelBuilder
extends ViewModelBuilder<List<IEvent>> {
    private static final int CANCEL_CHECK_EVERY_X = 10000;
    private static final int MAX_TABLE_ROWS = 100000;

    public TableModelBuilder(IServiceLocator locator, ColumnDescriptorRepository columnDescriptorRepository, ComponentDescriptor cd) {
        super(locator, cd.getName());
    }

    @Override
    protected List<IEvent> buildModel(IView view, IProgressMonitor monitor) {
        ArrayList<IEvent> list = new ArrayList<IEvent>();
        int counter = 0;
        for (IEvent event : view) {
            list.add(event);
            if (counter++ % 10000 == 0 && monitor.isCanceled()) {
                return list;
            }
            if (counter != 100000) continue;
            this.setLastBuildMessage("Too many events to fit table. Will only show the first 100000");
            return list;
        }
        return list;
    }
}

