/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.LabelDrawer;
import com.jrockit.mc.flightrecorder.ui.components.graph.TransitionDrawer;
import com.jrockit.mc.flightrecorder.ui.components.graph.TreeLeafFilter;
import com.jrockit.mc.flightrecorder.ui.components.graph.TreeNodeWrapper;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderingComponent;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.ui.AWTImages;
import com.jrockit.mc.ui.misc.SwingSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.eclipse.swt.graphics.Point;

public class EventGraphTree
extends JComponent {
    private static final int LABEL_WIDTH = 100;
    private static final long serialVersionUID = -3827734376369154094L;
    private transient UIModel latencyUIModel;
    private transient TreeLeafFilter treeFilter;
    private ArrayList rows;
    private final HashSet selectionSet;
    private transient TreeNodeWrapper rootNode;
    private final HashMap drawnHandles = new HashMap();
    private static final int INDENT = 21;
    private int minimumRowHeight = 18;
    private int rowHeight = 18;
    public int leftColumnWidth = 170;
    private Icon collapsedIcon;
    private Icon expandedIcon;
    private final Color labelTextColor;
    private final Color backgroundColor = GraphHelper.DEFAULT_BACKGROUND_COLOR.getAWTColor();
    private final Color foregroundColor = GraphHelper.DEFAULT_FOREGROUND_COLOR.getAWTColor();
    private final Color selectionBackground;
    private final Color selectionForeground;
    private final Font treeFont;
    private final transient BasicStroke lineStroke;
    private final JLabel drawLabel;
    private final RenderingComponent threadRenderer;
    private transient IVisitor selectionFilter;
    HashSet expansionState = new HashSet();
    private transient TransitionDrawer transitionDrawer;
    private final transient LabelDrawer labelDrawer;
    private double xTranslation = 0.0;
    private double yTranslation = 0.0;
    private int lastToggledRow = -1;

    public EventGraphTree(RenderingComponent renderer) {
        this.selectionSet = new HashSet();
        this.rows = new ArrayList();
        this.threadRenderer = renderer;
        SwingSupport.initLookAndFeel();
        this.setDoubleBuffered(false);
        this.treeFont = UIManager.getFont("Tree.font");
        this.collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        this.expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        if (!SwingSupport.IS_WINDOWS || this.collapsedIcon == null || this.expandedIcon == null || this.collapsedIcon.getIconWidth() < 5 || this.expandedIcon.getIconHeight() < 5) {
            BufferedImage bufImg = new BufferedImage(9, 9, 1);
            Graphics2D g2 = bufImg.createGraphics();
            g2.fillRect(0, 0, bufImg.getWidth(), bufImg.getHeight());
            g2.setColor(new Color(66, 66, 160));
            g2.drawRect(0, 0, bufImg.getWidth() - 1, bufImg.getHeight() - 1);
            g2.setColor(new Color(0, 0, 0));
            g2.drawLine(2, bufImg.getHeight() / 2, bufImg.getWidth() - 3, bufImg.getHeight() / 2);
            this.expandedIcon = new ImageIcon(bufImg);
            bufImg = new BufferedImage(9, 9, 1);
            g2 = bufImg.createGraphics();
            g2.fillRect(0, 0, bufImg.getWidth(), bufImg.getHeight());
            g2.setColor(new Color(66, 66, 160));
            g2.drawRect(0, 0, bufImg.getWidth() - 1, bufImg.getHeight() - 1);
            g2.setColor(new Color(0, 0, 0));
            g2.drawLine(2, bufImg.getHeight() / 2, bufImg.getWidth() - 3, bufImg.getHeight() / 2);
            g2.drawLine(bufImg.getWidth() / 2, 2, bufImg.getWidth() / 2, bufImg.getHeight() - 3);
            this.collapsedIcon = new ImageIcon(bufImg);
        }
        this.labelTextColor = UIManager.getColor("List.foreground");
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        this.lineStroke = new BasicStroke(0.01f, 0, 1, 1.0f, new float[]{1.5f, 1.5f}, 0.0f);
        this.drawLabel = new JLabel();
        if (this.treeFont != null) {
            this.drawLabel.setFont(this.treeFont);
        }
        this.drawLabel.setOpaque(false);
        FontMetrics metrics = this.getFontMetrics(this.treeFont);
        this.minimumRowHeight = metrics.getAscent() + metrics.getDescent() + 4;
        this.setRowHeight(this.minimumRowHeight);
        this.drawLabel.setSize(new Dimension(100, this.minimumRowHeight));
        this.labelDrawer = new LabelDrawer(this.minimumRowHeight);
        this.setFilter(null);
    }

    public LabelDrawer getLabelDrawer() {
        return this.labelDrawer;
    }

    public int getLeftColumnWidth() {
        return this.leftColumnWidth;
    }

    public int getMaxRowHeight() {
        return this.rowHeight;
    }

    public RenderingComponent getRenderingComponent() {
        return this.threadRenderer;
    }

    public void setData(UIModel model, IVisitor selectionFilter) {
        this.latencyUIModel = model;
        this.selectionFilter = selectionFilter;
        ArrayList<Visitable> topNodes = new ArrayList<Visitable>();
        topNodes.add(this.latencyUIModel.getUIComponents().getGarbageCollector());
        topNodes.addAll(this.latencyUIModel.getUIComponents().getThreadGroups());
        this.setRoot(new TreeNodeWrapper(null, topNodes, this.treeFilter, selectionFilter));
        Iterator iter = this.selectionSet.iterator();
        while (iter.hasNext()) {
            if (this.rootNode.subtreeContainsData(iter.next())) continue;
            iter.remove();
        }
        this.restoreExpansionState();
    }

    public void setFilter(TreeLeafFilter filter) {
        this.treeFilter = filter == null ? new AcceptingTreeFilter() : filter;
        this.clearSelection();
        if (this.latencyUIModel != null) {
            this.setData(this.latencyUIModel, this.selectionFilter);
        }
    }

    private void setRoot(TreeNodeWrapper root) {
        this.rows.clear();
        this.drawnHandles.clear();
        this.rootNode = root;
        int i = 0;
        while (i < root.getChildCount()) {
            this.rows.add(root.getChildAt(i));
            ++i;
        }
    }

    public void expandAll() {
        this.clearExpansionState();
        int i = 0;
        while (i < this.rows.size()) {
            int oldSize = this.rows.size();
            if (this.isEligibleForExpansion(i)) {
                this.expandRow(i);
            }
            i += this.rows.size() - oldSize;
            ++i;
        }
    }

    private void clearExpansionState() {
        this.expansionState.clear();
    }

    private void restoreExpansionState() {
        block0: for (Object elementToExpand : this.expansionState) {
            int j = 0;
            while (j < this.rows.size()) {
                if (this.getNodeAtRow(j).getData().equals(elementToExpand)) {
                    this.expandRow(j);
                    continue block0;
                }
                ++j;
            }
        }
    }

    public boolean isExpanded(Object data) {
        int i = 0;
        while (i < this.rows.size()) {
            if (this.getNodeAtRow(i).getData() == data) {
                return this.isExpanded(i);
            }
            ++i;
        }
        return false;
    }

    public Object[] getSelectedData() {
        return this.selectionSet.toArray();
    }

    private void expandRow(int row) {
        TreeNodeWrapper node = this.getNodeAtRow(row);
        this.expansionState.add(node.getData());
        ArrayList l = new ArrayList();
        l.addAll(this.rows.subList(0, row + 1));
        l.addAll(node.getChildren());
        l.addAll(this.rows.subList(row + 1, this.rows.size()));
        this.rows = l;
    }

    private void collapseRow(int row) {
        TreeNodeWrapper node = this.getNodeAtRow(row);
        this.expansionState.remove(node.getData());
        while (row + 1 < this.rows.size()) {
            if (!this.isDescendentTo(node, this.getNodeAtRow(row + 1))) break;
            this.selectionSet.remove(((TreeNodeWrapper)this.rows.remove(row + 1)).getData());
        }
    }

    private TreeNodeWrapper getNodeAtRow(int row) {
        return (TreeNodeWrapper)this.rows.get(row);
    }

    private boolean isEligibleForExpansion(int row) {
        return this.getNodeAtRow(row).getChildCount() > 0;
    }

    private boolean isExpanded(int row) {
        return this.rows.size() > row + 1 && this.getNodeAtRow(row + 1).getParent() == this.getNodeAtRow(row);
    }

    private boolean isDescendentTo(TreeNodeWrapper parent, TreeNodeWrapper possibleDescendent) {
        while (possibleDescendent.getParent() != null && possibleDescendent.getParent() != parent) {
            possibleDescendent = (TreeNodeWrapper)possibleDescendent.getParent();
        }
        return possibleDescendent.getParent() != null;
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.threadRenderer.getRenderer().getObjectLocator().resize(this.getPreferredSize().height + 300);
        this.drawnHandles.clear();
        Graphics2D g2 = (Graphics2D)g;
        this.yTranslation = g2.getTransform().getTranslateY();
        this.xTranslation = g2.getTransform().getTranslateX();
        g2.setColor(this.backgroundColor);
        g2.fillRect(0, 0, this.getWidth(), Math.max(this.getPreferredSize().height, this.getHeight()));
        g2.setBackground(this.backgroundColor);
        g2.setColor(this.foregroundColor);
        double translateY = g2.getTransform().getTranslateY();
        int startRow = (int)(-translateY) / this.rowHeight;
        int rowsToDraw = Math.min(this.rows.size() - startRow, this.getHeight() / this.rowHeight + 2);
        Color lineCol = this.blend(g2.getBackground(), g2.getColor());
        int i = rowsToDraw - 1;
        while (i >= 0) {
            this.drawRow(g2, startRow + i, 0, (i + startRow) * this.rowHeight, lineCol);
            --i;
        }
        if (this.transitionDrawer != null) {
            try {
                this.transitionDrawer.setWidth(this.getPreferredSize().width - this.leftColumnWidth);
                this.transitionDrawer.clearYValues();
                this.transitionDrawer.setRowHeight(this.rowHeight);
                this.transitionDrawer.addYValuesFromTreeNodes(this.rows, this.rowHeight, 0);
                this.transitionDrawer.addYvaluesFromLocator(this.threadRenderer.getRenderer().getObjectLocator(), 0);
                g2.translate(this.leftColumnWidth, 0);
                this.transitionDrawer.draw(g2);
                g2.translate(-this.leftColumnWidth, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int getNumParentsAfterRoot(TreeNodeWrapper node) {
        int n = 0;
        while (node.getParent() != this.rootNode) {
            node = (TreeNodeWrapper)node.getParent();
            ++n;
        }
        return n;
    }

    private boolean hasMoreSiblings(TreeNodeWrapper node) {
        if (node == this.rootNode) {
            return false;
        }
        TreeNodeWrapper parent = (TreeNodeWrapper)node.getParent();
        return parent.getIndex(node) < parent.getChildCount() - 1;
    }

    private void drawRow(Graphics2D g2, int row, int x, int y, Color lineCol) {
        g2.setStroke(this.lineStroke);
        g2.setColor(lineCol);
        TreeNodeWrapper node = (TreeNodeWrapper)this.rows.get(row);
        int rowIndent = this.getNumParentsAfterRoot(node);
        while (rowIndent > 0) {
            if (this.hasMoreSiblings((TreeNodeWrapper)node.getParent())) {
                this.drawChildLine(g2, row, x, y, false, this.hasMoreSiblings(node));
            }
            x += 21;
            --rowIndent;
        }
        if (this.isEligibleForExpansion(row)) {
            this.drawHandle(g2, row, x, y, this.hasMoreSiblings(node));
        } else {
            this.drawChildLine(g2, row, x, y, true, this.hasMoreSiblings(node));
        }
        this.draw16x16Icon(g2, node, x += 21, y, row);
        this.drawRowName(g2, node, x + 16, y, row);
        this.drawThreadData(g2, node.getData(), x + 16, y, row);
    }

    private void draw16x16Icon(Graphics2D g2, TreeNodeWrapper node, int x, int y, int row) {
        int IMAGE_SIZE = 16;
        AWTImages.assertHeight((Image)AWTImages.THREAD, (int)16);
        AWTImages.assertHeight((Image)AWTImages.THREAD_GROUP, (int)16);
        AWTImages.assertHeight((Image)AWTImages.TRASH, (int)16);
        Object object = node.getData();
        int centeredY = y + (this.rowHeight - 16) / 2;
        if (object instanceof UIThread) {
            g2.drawImage(AWTImages.THREAD, x, centeredY, null);
        }
        if (object instanceof UIThreadGroup) {
            g2.drawImage(AWTImages.THREAD_GROUP, x, centeredY, null);
        }
        if (object instanceof UIGarbageCollector) {
            g2.drawImage(AWTImages.TRASH, x, centeredY, null);
        }
    }

    private Color blend(Color background, Color color) {
        return new Color((int)Math.round(0.75 * (double)color.getRed() + 0.25 * (double)background.getRed()), (int)Math.round(0.75 * (double)color.getGreen() + 0.25 * (double)background.getGreen()), (int)Math.round(0.75 * (double)color.getBlue() + 0.25 * (double)background.getBlue()));
    }

    private void drawThreadData(Graphics2D g2, Object data, int x, int y, int row) {
        int xt = this.leftColumnWidth;
        int yt = y;
        g2.translate(xt, yt);
        this.threadRenderer.getRenderer().setCoord(xt, y);
        this.threadRenderer.getRenderer().setIndex(row);
        this.threadRenderer.getRenderer().setUIModel(this.latencyUIModel);
        this.threadRenderer.getRenderer().setInput((Visitable)data);
        this.threadRenderer.setSize(this.getWidth() - this.leftColumnWidth, this.rowHeight);
        this.threadRenderer.paint(g2);
        g2.translate(-xt, -yt);
    }

    private void drawRowName(Graphics2D g2, TreeNodeWrapper node, int x, int y, int index) {
        this.drawRowSelection(g2, node, x, y, index);
        this.labelDrawer.drawLabel(g2, new Rectangle(x, y, 100, this.rowHeight), node.getName());
    }

    private void drawRowSelection(Graphics2D g2, TreeNodeWrapper node, int x, int y, int index) {
        if (this.selectionSet.contains(node.getData())) {
            g2.setColor(this.selectionBackground);
            g2.fillRect(x, y, this.leftColumnWidth - x, this.rowHeight);
            this.drawLabel.setForeground(this.selectionForeground);
        } else {
            g2.setColor(this.threadRenderer.getRenderer().getChartConfig().getThreadBackgroundColor(index));
            g2.fillRect(x, y, this.leftColumnWidth - x, this.rowHeight);
            this.drawLabel.setForeground(this.labelTextColor);
        }
    }

    private void drawHandle(Graphics2D g2, int row, int x, int y, boolean hasMoreSiblings) {
        Icon iconToDraw = this.isExpanded(row) ? this.expandedIcon : this.collapsedIcon;
        int handleTop = y + (this.rowHeight - iconToDraw.getIconHeight()) / 2;
        Rectangle rect = new Rectangle(x + (21 - iconToDraw.getIconWidth()) / 2, handleTop, iconToDraw.getIconWidth(), iconToDraw.getIconHeight());
        iconToDraw.paintIcon(this, g2, rect.x, rect.y);
        --rect.x;
        --rect.y;
        rect.width += 2;
        rect.height += 2;
        this.drawnHandles.put(rect, row);
        if (row != 0) {
            g2.drawLine(x + 10, y, x + 10, handleTop);
        }
        if (hasMoreSiblings) {
            g2.drawLine(x + 10, handleTop + iconToDraw.getIconHeight(), x + 10, y + this.rowHeight);
        }
        g2.drawLine(x + 21 - (21 - iconToDraw.getIconWidth()) / 2, y + this.rowHeight / 2, x + 21, y + this.rowHeight / 2);
    }

    private void drawChildLine(Graphics2D g2, int row, int x, int y, boolean immediatelyBeforeChild, boolean hasMoreSiblings) {
        int endPoint = y + this.rowHeight;
        if (!hasMoreSiblings && immediatelyBeforeChild) {
            endPoint = y + this.rowHeight / 2;
        }
        g2.drawLine(x + 10, y, x + 10, endPoint);
        if (immediatelyBeforeChild) {
            g2.drawLine(x + 10, y + this.rowHeight / 2, x + 21, y + this.rowHeight / 2);
        }
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.rowHeight * this.rows.size());
    }

    public void setRowHeight(int height) {
        this.rowHeight = height;
    }

    public Object getElementBelowMousePoint(int x, int y) {
        Point p = this.translateSWTCoordToSwingCoord(x, y);
        int row = p.y / this.getRowHeight();
        if (row < this.rows.size() && x < this.leftColumnWidth) {
            return this.getNodeAtRow(row).getData();
        }
        return null;
    }

    public void performClick(int x, int y, boolean shiftPressed, boolean ctrlOrCmdPressed) {
        Point p = this.translateSWTCoordToSwingCoord(x, y);
        for (Rectangle rect : this.drawnHandles.keySet()) {
            if (!rect.contains(p.x, p.y)) continue;
            Integer row = (Integer)this.drawnHandles.get(rect);
            if (this.isExpanded(row)) {
                this.collapseRow(row);
                continue;
            }
            this.expandRow(row);
        }
        this.performClickSelections(p.x, p.y, shiftPressed, ctrlOrCmdPressed);
    }

    public Point translateSWTCoordToSwingCoord(int x, int y) {
        return new Point(x - (int)this.xTranslation, y - (int)this.yTranslation);
    }

    public Point translateSwingCoordToSWTCoord(int x, int y) {
        return new Point(x + (int)this.xTranslation, y + (int)this.yTranslation);
    }

    private void performClickSelections(int x, int y, boolean shiftPressed, boolean ctrlPressed) {
        int row = y / this.getRowHeight();
        if (row < this.rows.size() && x > (this.getNumParentsAfterRoot(this.getNodeAtRow(row)) + 1) * 21 && x < this.leftColumnWidth) {
            if (shiftPressed) {
                this.selectRange(this.lastToggledRow, row);
            } else if (ctrlPressed) {
                this.toggleSelection(row);
            } else {
                this.clearSelection();
                this.toggleSelection(row);
            }
        }
    }

    private void selectRange(int fromRow, int toRow) {
        this.clearSelection();
        if (fromRow < 0 || fromRow >= this.rows.size() || toRow == fromRow) {
            this.toggleSelection(toRow);
        } else {
            int direction = -(toRow - fromRow) / Math.abs(toRow - fromRow);
            int i = toRow;
            while (i != fromRow + direction) {
                this.selectionSet.add(this.getNodeAtRow(i).getData());
                i += direction;
            }
        }
    }

    private void toggleSelection(int row) {
        Object data = this.getNodeAtRow(row).getData();
        this.lastToggledRow = row;
        if (this.selectionSet.contains(data)) {
            this.selectionSet.remove(data);
        } else {
            this.selectionSet.add(data);
        }
    }

    void clearSelection() {
        this.selectionSet.clear();
    }

    public void expandTop() {
        if (this.rows.size() > 0 && this.isEligibleForExpansion(0)) {
            this.expandRow(0);
        }
    }

    public void setTransitionDrawer(TransitionDrawer drawer) {
        this.transitionDrawer = drawer;
    }

    public TransitionDrawer getTransitionDrawer() {
        return this.transitionDrawer;
    }

    public int getMinimumRowHeight() {
        return this.minimumRowHeight;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("EventGraphTrees should not be serialized!");
    }

    private static class AcceptingTreeFilter
    implements TreeLeafFilter {
        private AcceptingTreeFilter() {
        }

        @Override
        public boolean accept(TreeNodeWrapper wrapper) {
            return true;
        }
    }
}

