/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

class Marquee
implements MouseListener,
MouseMoveListener,
PaintListener {
    private final Composite m_container;
    private final ListenerList m_listeners = new ListenerList();
    private final Selection m_selection = new Selection();

    public Marquee(Composite c) {
        this.m_container = c;
        c.addMouseListener((MouseListener)this);
        c.addMouseMoveListener((MouseMoveListener)this);
        c.addPaintListener((PaintListener)this);
    }

    public void addSelectedRegionListener(ISelectedRegionListener listener) {
        this.m_listeners.add((Object)listener);
    }

    public void removeSelectedRegionListener(ISelectedRegionListener listener) {
        this.m_listeners.remove((Object)listener);
    }

    public Selection getSelection() {
        return this.m_selection;
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.getSelection().clear();
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
            this.getSelection().clear();
            this.getSelection().setStateMask(e.stateMask);
            this.getSelection().beginSelection(e.x, e.y);
            this.getSelection().endSelection(e.x, e.y);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.getSelection().isSelecting()) {
            Selection s = this.getSelection();
            s.endSelection(e.x, e.y);
            this.m_container.redraw();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.getSelection().isSelecting()) {
            this.getSelection().endSelection(e.x, e.y);
            this.getSelection().finishSelection();
            this.notifyListeners();
            this.getSelection().clear();
        }
    }

    private void notifyListeners() {
        Object[] listeners = this.m_listeners.getListeners();
        Selection selection = this.getSelection();
        Object[] objectArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (selection.getRectangle() != null) {
                ((ISelectedRegionListener)listener).onRegionSelect(selection.getStateMask(), selection.getRectangle());
            }
            ++n2;
        }
    }

    public void paintControl(PaintEvent e) {
        this.paintSelection(e.gc);
    }

    private void paintSelection(GC gc) {
        Selection selection = this.getSelection();
        if (!selection.isEmpty() && this.getSelection().isSelecting()) {
            gc.setLineStyle(3);
            gc.drawRectangle(selection.getRectangle());
        }
    }

    static interface ISelectedRegionListener {
        public void onRegionSelect(int var1, Rectangle var2);
    }

    public static class Selection {
        private static int NOT_SELECTED = -4711;
        private final Point m_begin = new Point(NOT_SELECTED, NOT_SELECTED);
        private final Point m_end = new Point(NOT_SELECTED, NOT_SELECTED);
        private final Rectangle m_rectangle = new Rectangle(0, 0, 0, 0);
        private boolean m_selecting;
        private int m_stateMask;

        public Rectangle getRectangle() {
            if (!this.isEmpty()) {
                this.m_rectangle.x = Math.min(this.m_begin.x, this.m_end.x);
                this.m_rectangle.y = Math.min(this.m_begin.y, this.m_end.y);
                this.m_rectangle.width = Math.max(this.m_begin.x, this.m_end.x) - this.m_rectangle.x;
                this.m_rectangle.height = Math.max(this.m_begin.y, this.m_end.y) - this.m_rectangle.y;
                return this.m_rectangle;
            }
            return null;
        }

        public Point getEnd() {
            return this.m_end;
        }

        public void beginSelection(int x, int y) {
            this.m_begin.x = x;
            this.m_begin.y = y;
            this.m_selecting = true;
        }

        public void finishSelection() {
            this.m_selecting = false;
        }

        public void endSelection(int x, int y) {
            this.m_end.x = x;
            this.m_end.y = y;
        }

        public boolean isSelecting() {
            return this.m_selecting;
        }

        public boolean isEmpty() {
            return this.m_begin.x == NOT_SELECTED || this.m_end.x == NOT_SELECTED;
        }

        public void clear() {
            this.m_begin.x = NOT_SELECTED;
            this.m_end.x = NOT_SELECTED;
        }

        public void setStateMask(int stateMask) {
            this.m_stateMask = stateMask;
        }

        public int getStateMask() {
            return this.m_stateMask;
        }
    }
}

