/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.TransitionLookup;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.Iterator;
import org.eclipse.core.runtime.ListenerList;

public class RangeManager {
    private final FlightRecording m_recording;
    private final ListenerList m_selectedRangeListeners = new ListenerList();
    private final ITimeRange m_totalRange;
    private ITimeRange m_selectedRange;
    private final TransitionLookup m_transitionLookup;

    public RangeManager(FlightRecording recording) {
        this.m_recording = recording;
        this.m_totalRange = recording.getTimeRange();
        this.m_selectedRange = new TimeRange(this.m_totalRange.getStartTimestamp(), this.m_totalRange.getEndTimestamp());
        this.m_transitionLookup = new TransitionLookup(recording);
    }

    public TransitionLookup getTransitionLookup() {
        return this.m_transitionLookup;
    }

    public ITimeRange getSelectedRange() {
        return this.m_selectedRange;
    }

    public ITimeRange getTotalRange() {
        return this.m_totalRange;
    }

    boolean sameRange(ITimeRange a, ITimeRange b) {
        if (a.getStartTimestamp() != b.getStartTimestamp()) {
            return false;
        }
        return a.getEndTimestamp() == b.getEndTimestamp();
    }

    public void setSelectedRange(Object source, ITimeRange range) {
        if (!this.sameRange(this.m_selectedRange, range)) {
            Object[] listeners;
            this.m_selectedRange = range;
            Object[] objectArray = listeners = this.m_selectedRangeListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                SelectedRangeChange s = (SelectedRangeChange)listener;
                if (s != source) {
                    s.onSelectedRangeChange(range);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        this.m_selectedRangeListeners.clear();
    }

    public Iterator getEventsInTotalRange() {
        return this.getEvents(ITimeRange.INFINITE_RANGE);
    }

    private Iterator getEvents(ITimeRange infiniteRange) {
        return this.m_recording.createView().iterator();
    }

    public void addSelecteRangeChangeListener(SelectedRangeChange listener) {
        this.m_selectedRangeListeners.add((Object)listener);
    }

    public void removeSelecteRangeChangeListener(SelectedRangeChange listener) {
        this.m_selectedRangeListeners.remove((Object)listener);
    }

    public long getCroppedSelectedRange() {
        long duration = this.m_selectedRange.getDuration();
        if (this.m_selectedRange.getDuration() == Long.MAX_VALUE) {
            duration = this.m_recording.getTimeRange().getEndTimestamp() - this.m_recording.getTimeRange().getStartTimestamp();
        }
        return duration;
    }

    public static interface SelectedRangeChange {
        public void onSelectedRangeChange(ITimeRange var1);
    }
}

