/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.core.MCConstants;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.RangeManager;
import com.jrockit.mc.flightrecorder.ui.components.graph.TransitionLookup;
import com.jrockit.mc.flightrecorder.ui.components.graph.TreeNodeWrapper;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ObjectLocator;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.misc.ToolTipManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TransitionDrawer {
    private static final Color TRANSITION_COLOR = Color.BLACK;
    private static final int HORIZONTAL_LINE_FUZZINESS = 1;
    private static final int VERTICAL_LINE_FUZZINESS = 1;
    private static final int MAX_TOOLTIP_TRANSITION_LINE_COUNT = 10;
    private static final BasicStroke STROKE = new BasicStroke();
    private static final int WIDTH = 4;
    private static final int HEIGHT = 11;
    private final Polygon UP_ARROW_POYGON;
    private final Polygon DOWN_ARROW_POLYGON;
    private final HashMap m_objectMap = new HashMap();
    private final RangeManager m_rangeManager;
    private final IVisitor m_selectionFilter;
    private final ChartConfiguration m_chartConfig;
    private int m_width;
    private int m_rowHeight;
    private long m_startTimeStamp;
    private long m_endTimeStamp;
    private double m_duration;
    private boolean m_tooManyTransition;
    private final FlightRecording m_recording;

    public TransitionDrawer(FlightRecording recording, RangeManager rangeManager, ChartConfiguration chartConfig, IVisitor selectionFilter) {
        this.m_recording = recording;
        this.m_chartConfig = chartConfig;
        this.m_rangeManager = rangeManager;
        this.m_selectionFilter = selectionFilter;
        this.UP_ARROW_POYGON = this.createArrow(true);
        this.DOWN_ARROW_POLYGON = this.createArrow(false);
    }

    public void draw(Graphics2D g2) {
        if (this.m_chartConfig.getShowTransition()) {
            this.updateRangeInformation();
            this.drawTransitions(g2);
        }
    }

    private void updateRangeInformation() {
        ITimeRange range = this.getRangeManager().getSelectedRange();
        this.m_startTimeStamp = range.getStartTimestamp();
        this.m_endTimeStamp = range.getEndTimestamp();
        this.m_duration = this.m_endTimeStamp - this.m_startTimeStamp;
    }

    private void drawTransitions(Graphics2D g2) {
        Color origColor = g2.getColor();
        g2.setColor(TRANSITION_COLOR);
        g2.setStroke(STROKE);
        ArrayList allTracks = new ArrayList(this.m_recording.getRootGroup().getAllTracks());
        IView view = this.m_recording.createView();
        view.setRange(this.getRangeManager().getSelectedRange());
        view.setExpansion(Expansion.NORMAL);
        view.setFilter((IEventFilter)this.m_selectionFilter);
        view.setEventTypes(this.createAcceptedTypes(this.m_recording.getEventTypes()));
        int counter = 0;
        int maxCount = this.getMaxCount();
        int n = 0;
        while (n < allTracks.size() && counter < maxCount) {
            view.setTracks(allTracks.subList(n, n + 1));
            counter += this.drawTracksTransitions(g2, view, (ITrack)allTracks.get(n));
            ++n;
        }
        g2.setColor(origColor);
        this.setTooManyTransition(counter >= maxCount);
    }

    private Collection<IEventType> createAcceptedTypes(Collection<? extends IEventType> eventTypes) {
        ArrayList<IEventType> accepted = new ArrayList<IEventType>(eventTypes.size());
        for (IEventType iEventType : eventTypes) {
            if (!EventToolkit.isVisible(iEventType) || !EventToolkit.hasTransition(iEventType)) continue;
            accepted.add(iEventType);
        }
        return accepted;
    }

    int drawTracksTransitions(Graphics2D g2, IView view, ITrack track) {
        int counter = 0;
        for (IEvent event : view) {
            ++counter;
            this.drawTransition(g2, event, track);
        }
        return counter;
    }

    private void setTooManyTransition(boolean tooMany) {
        this.m_tooManyTransition = tooMany;
    }

    public boolean hasTooManyTransition() {
        return this.m_tooManyTransition;
    }

    private void drawTransition(Graphics2D g2, IEvent e, ITrack trackDescriptor) {
        RangeManager m = this.getRangeManager();
        int eventStartX = this.getDeviceXForTimestamp(e.getStartTimestamp());
        int eventEndX = this.getDeviceXForTimestamp(e.getEndTimestamp());
        PositionInfo eventY = this.getDeviceYPositionForEvent(this.getThread(e), trackDescriptor);
        PositionInfo fromThreadY = this.getDeviceYPositionForEvent(m.getTransitionLookup().getTransitionFrom(e), null);
        PositionInfo toThreadY = this.getDeviceYPositionForEvent(m.getTransitionLookup().getTransitionTo(e), null);
        if (eventY != null) {
            if (eventStartX > 0 && toThreadY != null) {
                this.drawArrowLine(g2, eventStartX, toThreadY, eventStartX, eventY);
            }
            if (eventEndX > 0 && fromThreadY != null) {
                this.drawArrowLine(g2, eventEndX, fromThreadY, eventEndX, eventY);
            }
        }
    }

    public void clearYValues() {
        this.m_objectMap.clear();
    }

    public void setRowHeight(int height) {
        this.m_rowHeight = height;
    }

    public void addYvaluesFromLocator(ObjectLocator locator, int position) {
        int size = locator.getSize();
        Visitable lastObject = null;
        int lastPosition = -1;
        int objectPosition = 0;
        while (objectPosition < size) {
            Visitable object = locator.getObjectAt(objectPosition);
            if (object != lastObject) {
                if (lastPosition != -1) {
                    int middle = (lastPosition + objectPosition - 1) / 2;
                    if (lastObject instanceof UITrack) {
                        UITrack uil = (UITrack)lastObject;
                        for (ITrack td : uil.getTrackDescriptors()) {
                            this.storeObjectmap(td, middle);
                        }
                    }
                    if (lastObject instanceof UIThread) {
                        this.storeObjectmap2(((UIThread)lastObject).getThread(), middle);
                    }
                }
                lastPosition = objectPosition;
            }
            lastObject = object;
            ++objectPosition;
        }
    }

    public void addYValuesFromTreeNodes(Collection treeNodes, int rowIncrease, int position) {
        for (TreeNodeWrapper treeNodeWrapper : treeNodes) {
            Object data = treeNodeWrapper.getData();
            if (data instanceof UIThread) {
                this.storeObjectmap(((UIThread)data).getThread(), position + this.m_rowHeight / 2);
            }
            if (treeNodeWrapper.getChildCount() > 0) {
                this.addYValuesFromTreeNodes(treeNodeWrapper.getChildren(), 0, position);
            }
            position += rowIncrease;
        }
    }

    private void storeObjectmap(Object o, int position) {
        this.m_objectMap.put(o, new PositionInfo(position, position));
    }

    private void storeObjectmap2(Object o, int position) {
        PositionInfo positionInfoObject = (PositionInfo)this.m_objectMap.get(o);
        if (positionInfoObject == null) {
            this.storeObjectmap(o, position);
        } else {
            positionInfoObject.setBottom(Math.max(positionInfoObject.getBottom(), position));
            positionInfoObject.setTop(Math.min(positionInfoObject.getTop(), position));
        }
    }

    public PositionInfo getDeviceYPositionForEvent(Object thread, ITrack descriptor) {
        Object object1 = this.m_objectMap.get(descriptor);
        if (object1 != null) {
            return (PositionInfo)object1;
        }
        Object object2 = this.m_objectMap.get(thread);
        if (object2 != null) {
            return (PositionInfo)object2;
        }
        return null;
    }

    public void dispose() {
    }

    private int getDeviceXForTimestamp(long timeStamp) {
        double pixelDelta;
        if (timeStamp >= this.m_startTimeStamp && timeStamp <= this.m_endTimeStamp && (pixelDelta = this.m_duration / (double)this.m_width) != 0.0) {
            int pixel = (int)((double)(timeStamp - this.m_startTimeStamp) / pixelDelta);
            return pixel - pixel % 2;
        }
        return -1;
    }

    private void drawArrowLine(Graphics2D gc, int threadX, PositionInfo transitionThread, int eventX, PositionInfo eventY) {
        if (transitionThread.getTop() == eventY.getTop()) {
            return;
        }
        if (transitionThread.getBottom() > eventY.getTop()) {
            gc.drawLine(threadX - 4, transitionThread.getTop(), threadX + 4, transitionThread.getTop());
            gc.drawLine(threadX, transitionThread.getTop(), eventX, eventY.getTop());
            gc.translate(eventX, eventY.getTop());
            gc.fillPolygon(this.UP_ARROW_POYGON);
            gc.translate(-eventX, -eventY.getTop());
        } else {
            gc.drawLine(threadX - 4, transitionThread.getBottom(), threadX + 4, transitionThread.getBottom());
            gc.drawLine(threadX, transitionThread.getBottom(), eventX, eventY.getBottom());
            gc.translate(eventX, eventY.getBottom());
            gc.fillPolygon(this.DOWN_ARROW_POLYGON);
            gc.translate(-eventX, -eventY.getBottom());
        }
    }

    private Polygon createArrow(boolean up) {
        int[] arrowHeadX = new int[]{-4, 4, 0, -4};
        int[] arrowHeadY = new int[]{up ? 11 : -11, up ? 11 : -11, 0, up ? 11 : -11};
        return new Polygon(arrowHeadX, arrowHeadY, 4);
    }

    private int getMaxCount() {
        return Integer.MAX_VALUE;
    }

    private RangeManager getRangeManager() {
        return this.m_rangeManager;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public ArrayList getTransitions(int x, int y) {
        ArrayList tranistions = new ArrayList();
        if (!this.hasTooManyTransition()) {
            ArrayList allTracks = new ArrayList(this.m_recording.getRootGroup().getAllTracks());
            IView view = this.m_recording.createView();
            view.setRange(this.getRangeManager().getSelectedRange());
            view.setExpansion(Expansion.NORMAL);
            view.setFilter((IEventFilter)this.m_selectionFilter);
            view.setEventTypes(this.createAcceptedTypes(this.m_recording.getEventTypes()));
            int counter = 0;
            int n = 0;
            while (n < allTracks.size() && counter < 10) {
                view.setTracks(allTracks.subList(n, n + 1));
                for (IEvent event : view) {
                    counter += this.addTransitionsForEvent(tranistions, event, (ITrack)allTracks.get(n), x, y);
                }
                ++n;
            }
        }
        return tranistions;
    }

    IMCThread getThread(IEvent event) {
        return (IMCThread)event.getValue("(thread)");
    }

    private int addTransitionsForEvent(List tranistions, IEvent e, ITrack track, int x, int y) {
        int added = 0;
        TransitionLookup l = this.getRangeManager().getTransitionLookup();
        int eventStartX = this.getDeviceXForTimestamp(e.getStartTimestamp());
        int eventEndX = this.getDeviceXForTimestamp(e.getEndTimestamp());
        PositionInfo eventY = this.getDeviceYPositionForEvent(this.getThread(e), track);
        PositionInfo fromThreadY = this.getDeviceYPositionForEvent(l.getTransitionFrom(e), null);
        PositionInfo toThreadY = this.getDeviceYPositionForEvent(l.getTransitionTo(e), null);
        if (eventY != null) {
            if (eventStartX > 0 && toThreadY != null && this.hitTest(eventStartX, toThreadY, eventStartX, eventY, x, y)) {
                tranistions.add(new Transition(e, this.formatThreadName(this.getThread(e)), this.formatTransitionTo(e)));
                ++added;
            }
            if (eventEndX > 0 && fromThreadY != null && this.hitTest(eventEndX, fromThreadY, eventEndX, eventY, x, y)) {
                tranistions.add(new Transition(e, this.formatTransitionFrom(e), this.formatThreadName(this.getThread(e))));
                ++added;
            }
        }
        return added;
    }

    private boolean hitTest(int threadX, PositionInfo transitionThread, int eventX, PositionInfo eventY, int x, int y) {
        if (transitionThread.getTop() == eventY.getTop()) {
            return false;
        }
        if (transitionThread.getBottom() > eventY.getTop()) {
            if (this.hitTestRectangle(x, y, threadX - 4, transitionThread.getTop(), threadX + 4, transitionThread.getTop())) {
                return true;
            }
            if (this.hitTestRectangle(x, y, threadX, transitionThread.getTop(), eventX, eventY.getTop())) {
                return true;
            }
            return this.UP_ARROW_POYGON.contains(x - eventX, y - eventY.getTop());
        }
        if (this.hitTestRectangle(x, y, threadX - 4, transitionThread.getBottom(), threadX + 4, transitionThread.getBottom())) {
            return true;
        }
        if (this.hitTestRectangle(x, y, threadX, transitionThread.getBottom(), eventX, eventY.getBottom())) {
            return true;
        }
        return this.DOWN_ARROW_POLYGON.contains(x - eventX, y - eventY.getBottom());
    }

    private boolean hitTestRectangle(int x, int y, int fromX, int fromY, int toX, int toY) {
        int leftX = Math.min(fromX, toX);
        int rightX = Math.max(fromX, toX);
        int topY = Math.min(fromY, toY);
        int bottomY = Math.max(fromY, toY);
        return leftX - 1 <= x && x <= rightX + 1 && topY - 1 <= y && y <= bottomY + 1;
    }

    public String getTooltipTextAt(int x, int y) {
        ArrayList list = this.getTransitions(x, y);
        TreeMap<String, Integer> fromMap = new TreeMap<String, Integer>();
        TreeMap<String, Integer> toMap = new TreeMap<String, Integer>();
        for (Transition t : list) {
            TransitionDrawer.addTransitionNameToCounterMap(fromMap, t.getFromName());
            TransitionDrawer.addTransitionNameToCounterMap(toMap, t.getToName());
        }
        if (!fromMap.isEmpty() && !toMap.isEmpty()) {
            return this.formatTooltipText(fromMap, toMap, list.size() > 1);
        }
        return null;
    }

    private String formatTooltipText(Map<String, Integer> fromMap, Map<String, Integer> toMap, boolean multiple) {
        String message = "<form>";
        message = String.valueOf(message) + ToolTipManager.formatBoldRow((String)(multiple ? Messages.TRACK_COMPONENT_MULTIPLE_TRANSITION_FROM_TEXT : Messages.TRACK_COMPONENT_SINGLE_TRANSITION_FROM_TEXT));
        message = String.valueOf(message) + this.formatTransitions(fromMap, multiple);
        message = String.valueOf(message) + ToolTipManager.formatBoldRow((String)(multiple ? Messages.TRACK_COMPONENT_MULTIPLE_TRANSITION_TO_TEXT : Messages.TRACK_COMPONENT_SINGLE_TRANSITION_TO_TEXT));
        message = String.valueOf(message) + this.formatTransitions(toMap, multiple);
        message = String.valueOf(message) + "</form>";
        return message;
    }

    private static void addTransitionNameToCounterMap(Map<String, Integer> map, String name) {
        Integer counter = map.get(name);
        if (counter == null) {
            map.put(name, 1);
        } else {
            map.put(name, counter + 1);
        }
    }

    private String formatTransitions(Map<String, Integer> transitionCountMap, boolean showCount) {
        int lineCount = 0;
        String message = "";
        Iterator<Map.Entry<String, Integer>> it = transitionCountMap.entrySet().iterator();
        while (it.hasNext() && lineCount < 10) {
            ++lineCount;
            Map.Entry<String, Integer> entry = it.next();
            Integer count = entry.getValue();
            message = showCount ? String.valueOf(message) + ToolTipManager.formatRowPrimitive((String)(String.valueOf(ToolTipManager.htmlify((String)entry.getKey())) + "  <b>(" + count + ")</b>")) : String.valueOf(message) + ToolTipManager.formatRow((String)entry.getKey());
        }
        if (lineCount == 10) {
            message = String.valueOf(message) + ToolTipManager.formatRow((String)"...");
        }
        return message;
    }

    private String formatTransitionFrom(IEvent e) {
        String threadName = this.getTransitionLookup().getTransitionFrom(e).getThreadName();
        String fieldname = this.getTransitionLookup().getTransitionFromField(e).getName();
        return String.valueOf(fieldname) + ": " + threadName;
    }

    TransitionLookup getTransitionLookup() {
        return this.getRangeManager().getTransitionLookup();
    }

    private String formatTransitionTo(IEvent e) {
        String threadName = this.getTransitionLookup().getTransitionTo(e).getThreadName();
        String fieldname = this.getTransitionLookup().getTransitionToField(e).getName();
        return String.valueOf(fieldname) + ": " + threadName;
    }

    private String formatThreadName(IMCThread thread) {
        return "Thread: " + (thread != null ? thread.getThreadName() : MCConstants.NOT_AVAILABLE);
    }

    private static final class PositionInfo {
        private int m_top;
        private int m_bottom;

        public PositionInfo(int top, int bottom) {
            this.m_top = top;
            this.m_bottom = bottom;
        }

        void setTop(int position) {
            this.m_top = position;
        }

        void setBottom(int position) {
            this.m_bottom = position;
        }

        int getBottom() {
            return this.m_bottom;
        }

        int getTop() {
            return this.m_top;
        }
    }

    public static final class Transition {
        private final IEvent m_event;
        private final String m_fromObject;
        private final String m_toObject_;

        public Transition(IEvent event, String fromObject, String toObject) {
            this.m_event = event;
            this.m_fromObject = fromObject;
            this.m_toObject_ = toObject;
        }

        public String getFromName() {
            return this.m_fromObject;
        }

        public String getToName() {
            return this.m_toObject_;
        }

        public IEvent getAssociatedEvent() {
            return this.m_event;
        }
    }
}

