/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.TreeLeafFilter;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;

class TreeNodeWrapper
implements TreeNode,
Comparable<TreeNodeWrapper> {
    private final TreeNodeWrapper parentNode;
    private final Object wrappedData;
    private final Vector children = new Vector();
    private final IVisitor visibilityVisitor;

    public TreeNodeWrapper(TreeNodeWrapper parent, Object data, TreeLeafFilter filter, IVisitor sFilter) {
        this.parentNode = parent;
        this.wrappedData = data;
        this.visibilityVisitor = sFilter;
        if (!this.isLeaf()) {
            Iterator<Object> iter = this.wrappedData instanceof Collection ? ((Collection)this.wrappedData).iterator() : ((UIThreadGroup)this.wrappedData).getThreads().iterator();
            while (iter.hasNext()) {
                TreeNodeWrapper wrapper = new TreeNodeWrapper(this, iter.next(), filter, this.visibilityVisitor);
                if (!this.internalFilter(wrapper, filter)) continue;
                this.children.add(wrapper);
            }
            Collections.sort(this.children);
        }
    }

    private boolean internalFilter(TreeNodeWrapper wrapper, TreeLeafFilter filter) {
        if (wrapper.isLeaf() && ((Visitable)wrapper.getData()).accept(this.visibilityVisitor)) {
            return filter.accept(wrapper);
        }
        return wrapper.getChildCount() > 0;
    }

    public Object getData() {
        return this.wrappedData;
    }

    public String getName() {
        if (this.wrappedData instanceof UIThreadGroup) {
            return ((UIThreadGroup)this.wrappedData).getName();
        }
        if (this.wrappedData instanceof UIThread) {
            return ((UIThread)this.wrappedData).getThreadName();
        }
        if (this.wrappedData instanceof UIGarbageCollector) {
            return ((UIGarbageCollector)this.wrappedData).toString();
        }
        return this.wrappedData.toString();
    }

    public Collection getChildren() {
        return this.children;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return !(this.wrappedData instanceof UIThread);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parentNode;
    }

    @Override
    public boolean isLeaf() {
        return !(this.wrappedData instanceof UIThreadGroup) && !(this.wrappedData instanceof Collection);
    }

    public boolean subtreeContainsData(Object data) {
        if (this.wrappedData == data) {
            return true;
        }
        int i = 0;
        while (i < this.getChildCount()) {
            if (((TreeNodeWrapper)this.getChildAt(i)).subtreeContainsData(data)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int compareTo(TreeNodeWrapper that) {
        if (this.wrappedData instanceof UIGarbageCollector) {
            return -1;
        }
        if (that.wrappedData instanceof UIGarbageCollector) {
            return 1;
        }
        String a = this.getName();
        String b = that.getName();
        return a.compareToIgnoreCase(b);
    }
}

