/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring;

import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.AbstractValueColor;
import java.awt.Color;
import java.util.Collection;
import java.util.Random;

final class ValueColor
extends AbstractValueColor {
    private final Color[] m_colorLookup = this.buildLookup();

    public ValueColor(Collection<IEventType> types, String attribteIdentifier, Color color) {
        super(types, attribteIdentifier, color, FieldType.values());
    }

    protected Color[] buildLookup() {
        Random r = new Random(4711L);
        Color[] colors = new Color[256];
        int n = 0;
        while (n < colors.length) {
            colors[n] = new Color(Color.HSBtoRGB(r.nextFloat(), 0.6f, 0.9f));
            ++n;
        }
        return colors;
    }

    @Override
    public Color getColor(IEvent e) {
        Object o = this.getEventValue(e);
        if (o != null) {
            return this.m_colorLookup[Math.abs(o.hashCode() % 256)];
        }
        return this.getDefaultColor();
    }
}

