/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.common.xml.EscapeToolkit;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.TooltipVerbosity;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.components.properties.EventRetrieverField;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.ColorProvider;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.misc.ToolTipManager;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.TimeField;
import com.jrockit.mc.ui.model.fields.TimeSpanField;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormText;

public class TooltipVisitor
implements IVisitor {
    protected static final int MAXIMUM_VISIBLE_STACK_TRACE_ELEMENTS = 10;
    private final ITimeRange m_range;
    private int m_pixel = -1;
    private final FormText m_toolTip;
    private final Field m_timeField;
    private final IEventFilter m_filter;
    private int m_eventcount;
    private final TooltipVerbosity m_verbosity;
    private final long m_recordingStartNanosTimestamp;
    private int m_formatted = 0;

    public TooltipVisitor(ITimeRange range, IEventFilter filter, int pixelX, FormText toolTip, ChartConfiguration config, FlightRecording recording) {
        this.m_range = range;
        this.m_pixel = pixelX;
        this.m_toolTip = toolTip;
        this.m_timeField = new TimeField(0);
        this.m_verbosity = config.getTooltipVerbosity();
        this.m_filter = filter;
        this.m_recordingStartNanosTimestamp = recording.getTimeRange().getStartTimestamp();
    }

    @Override
    public boolean visit(UIThread uiThread) {
        ITimeRange r = uiThread.getRange();
        NumberField nf = new NumberField(0);
        String html = "<form>";
        ResourceManager m = new ResourceManager((Composite)this.getFormText(), 255, 255, 255);
        this.getFormText().setImage("backgroundimage", m.getBackgroundImage());
        html = String.valueOf(html) + "<p><img href='thread.image'/><img href='backgroundimage'/><b> " + uiThread.getThreadName() + "</b></p>";
        html = String.valueOf(html) + this.formatStartTime(uiThread.getRange().getStartTimestamp());
        html = String.valueOf(html) + this.formatEndTime(uiThread.getRange().getEndTimestamp());
        html = String.valueOf(html) + this.formatDuration(r.getDuration());
        html = String.valueOf(html) + ToolTipManager.formatRow((String)MessageFormat.format(Messages.TRACK_COMPONENT_TOOLTIP_JAVA_THREAD_ID_TEXT, nf.formatObject((Object)uiThread.getThreadId())));
        html = String.valueOf(html) + "</form>";
        this.getFormText().setImage("thread.image", UIPlugin.getDefault().getImage("thread_obj.gif"));
        this.setToolTipText(html, true);
        return false;
    }

    @Override
    public boolean visit(UIThreadGroup uiTHreadGroup) {
        ResourceManager m = new ResourceManager((Composite)this.getFormText(), 255, 255, 255);
        NumberField nf = new NumberField(0);
        this.getFormText().setImage("threadgroup.image", UIPlugin.getDefault().getImage("threadgroup.gif"));
        this.getFormText().setImage("backgroundimage", m.getBackgroundImage());
        String html = "<form>";
        html = String.valueOf(html) + "<p><img href='threadgroup.image'/><img href='backgroundimage'/><b> " + uiTHreadGroup.getName() + "</b></p>";
        html = String.valueOf(html) + ToolTipManager.formatRow((String)MessageFormat.format(Messages.TRACK_COMPONENT_TOOLTIP_THREADS_IN_THREAD_GROUP_TEXT, nf.formatObject((Object)uiTHreadGroup.getThreads().size())));
        html = String.valueOf(html) + "</form>";
        this.setToolTipText(html, true);
        return true;
    }

    @Override
    public boolean visit(UITrack uiTrack) {
        Iterator<IEvent> it = uiTrack.iterator(this.m_filter, this.m_range, Expansion.NORMAL);
        this.m_eventcount = 0;
        while (it.hasNext()) {
            it.next();
            ++this.m_eventcount;
        }
        if (this.visit(uiTrack.getRenderInfo().getSampleComponent())) {
            return true;
        }
        if (this.m_range.getStartTimestamp() < uiTrack.getRange().getStartTimestamp()) {
            return false;
        }
        if (this.m_range.getEndTimestamp() > uiTrack.getRange().getEndTimestamp()) {
            return false;
        }
        String s = "";
        s = String.valueOf(s) + "<form>";
        s = String.valueOf(s) + "<p><b>" + uiTrack.getName() + "</b></p>";
        s = String.valueOf(s) + Messages.TRACK_COMPONENT_TOOLTIP_NO_EVENTS_HERE_TEXT;
        s = String.valueOf(s) + "</form>";
        this.setToolTipText(s, true);
        return true;
    }

    public boolean visit(ISampler sampler) {
        if (this.m_pixel > 0 && this.m_pixel < sampler.getSampleInfo().getSize()) {
            ITimeRange[] ranges = sampler.getSampleInfo().getMaxRanges();
            if (this.visit((IEvent)ranges[this.m_pixel])) {
                return true;
            }
            int i = 1;
            while (i < 3) {
                if (this.m_pixel + i < ranges.length && this.visit((IEvent)ranges[this.m_pixel + i]) || this.m_pixel - i >= 0 && this.visit((IEvent)ranges[this.m_pixel - i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void setToolTipText(String toolTipText, boolean tags) {
        if (toolTipText != null) {
            this.m_toolTip.setText(toolTipText, tags, true);
        }
    }

    public FormText getToolTip() {
        return this.m_toolTip;
    }

    @Override
    public boolean visit(UIGarbageCollector uiGarbageCollector) {
        ResourceManager m = new ResourceManager((Composite)this.getFormText(), 255, 255, 255);
        this.getFormText().setImage("threadgroup.image", UIPlugin.getDefault().getImage("trash.png"));
        this.getFormText().setImage("backgroundimage", m.getBackgroundImage());
        String html = "<form>";
        html = String.valueOf(html) + "<p><img href='threadgroup.image'/><img href='backgroundimage'/><b>" + Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_GC_HEADER + "</b></p>";
        html = String.valueOf(html) + Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_GC_INFORMATION;
        html = String.valueOf(html) + "</form>";
        this.setToolTipText(html, true);
        return true;
    }

    public FormText getFormText() {
        return this.m_toolTip;
    }

    public boolean isValid(long d) {
        return d > 0L && d != -4611686018427387904L && d != 0x3FFFFFFFFFFFFFFFL;
    }

    public long getMillisSinceRecordingStart(long timeNanos1970) {
        return (timeNanos1970 - this.m_recordingStartNanosTimestamp) / 1000000L;
    }

    public String formatStartTime(long startTime) {
        ++this.m_formatted;
        Long time = this.makeTimestampFormattable(startTime);
        return ToolTipManager.formatRow((String)(String.valueOf(Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_START_TEXT) + ": " + this.m_timeField.formatObject((Object)time)), (this.m_formatted == 1 ? 1 : 0) != 0);
    }

    private Long makeTimestampFormattable(long timeStamp) {
        return this.isValid(timeStamp) ? Long.valueOf(timeStamp / 1000000L) : null;
    }

    public String formatEndTime(long endTime) {
        ++this.m_formatted;
        Long time = this.makeTimestampFormattable(endTime);
        return ToolTipManager.formatRow((String)(String.valueOf(Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_END_TEXT) + ": " + this.m_timeField.formatObject((Object)time)), (this.m_formatted == 1 ? 1 : 0) != 0);
    }

    public String formatDuration(long duration) {
        ++this.m_formatted;
        Double durationObject = duration == Long.MAX_VALUE ? null : Double.valueOf((double)duration / 1000000.0);
        return ToolTipManager.formatRow((String)(String.valueOf(Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_DURATION_TEXT) + ": " + new TimeSpanField(0).formatObject((Object)durationObject)), (this.m_formatted == 1 ? 1 : 0) != 0);
    }

    @Override
    public boolean visit(IEvent event) {
        if (event != null) {
            String stackTraceText;
            String propertyText;
            MCColor color = new MCColor(event.getEventType().getColor());
            ResourceManager manager = new ResourceManager((Composite)this.getFormText(), color.getRed(), color.getGreen(), color.getBlue());
            this.getFormText().setImage("event.image", manager.getImage());
            this.getFormText().setImage("event.backgroundimage", manager.getBackgroundImage());
            this.getFormText().setColor("selected", manager.getSelectedColor());
            this.getFormText().setWhitespaceNormalized(false);
            String text = "";
            text = String.valueOf(text) + "<form>";
            text = String.valueOf(text) + "<p><img href='event.image'/><img href='event.backgroundimage'/>";
            text = String.valueOf(text) + "<b> ";
            text = String.valueOf(text) + event.getEventType().getName() + "  ";
            if (EventToolkit.isPartOfGraphSelecion(event)) {
                text = String.valueOf(text) + " (" + Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_SELECTED_TEXT + ") ";
            }
            text = String.valueOf(text) + "</b>";
            if (this.m_eventcount > 1) {
                text = String.valueOf(text) + " (" + Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_LONGEST_DURATION_TEXT + ")";
            }
            text = String.valueOf(text) + "</p>";
            if (this.m_eventcount > 1) {
                String t = MessageFormat.format(Messages.TRACK_COMPONENT_TOOLTIP_HTML_TOOLTIP_EVENT_NUMBER_DESCRIPTION_TEXT, this.m_eventcount);
                text = String.valueOf(text) + ToolTipManager.formatRow((String)t);
            }
            if ((this.m_verbosity == TooltipVerbosity.NORMAL || this.m_verbosity == TooltipVerbosity.FULL) && (propertyText = this.getEventPropertiesText(event)) != null) {
                text = String.valueOf(text) + propertyText;
            }
            if ((stackTraceText = this.formatStrackTrace(event)) != null) {
                text = String.valueOf(text) + Messages.THREAD_GRAPH_COMPONENT_TOOLTIP_STACK_TRACE_TEXT;
                text = String.valueOf(text) + this.formatStrackTrace(event);
            }
            text = String.valueOf(text) + "</form>";
            this.setToolTipText(text, true);
            return true;
        }
        return false;
    }

    public String getEventPropertiesText(IEvent event) {
        String s = "";
        EventRetrieverField er = new EventRetrieverField(0);
        er.setInput(event);
        for (IField r : event.getEventType().getFields()) {
            if (!r.isVisible() || r.isSynthetic() || !this.isValidContentType(r.getContentType()) || "(stackTrace)".equals(r.getIdentifier())) continue;
            s = String.valueOf(s) + ToolTipManager.formatRow((String)(String.valueOf(r.getName()) + ": " + EscapeToolkit.escape((String)er.formatObject(r))));
        }
        return s;
    }

    private boolean isValidContentType(String contentTypeString) {
        if ("metadata".equals(contentTypeString)) {
            return false;
        }
        return !"stackTrace".equals(contentTypeString);
    }

    private String formatStrackTrace(IEvent event) {
        StringBuilder traceBuilder = new StringBuilder();
        Object value = event.getValue("(stackTrace)");
        if (value instanceof IMCStackTrace) {
            IMCStackTrace s = (IMCStackTrace)value;
            if (s.getFrames() != null && s.getFrames().size() > 0) {
                int rowIndex = 0;
                int count = s.getFrames().size();
                for (IMCFrame frame : s.getFrames()) {
                    IMCMethod method = frame.getMethod();
                    Object[] values = new Object[]{method.getHumanReadable(false, false, true, true, true, false)};
                    String text = MessageFormat.format(Messages.THREAD_GRAPH_COMPONENT_TOOLTIP_STACK_TRACE_AT_TEXT, values);
                    traceBuilder.append(ToolTipManager.formatRow((String)text));
                    if (rowIndex == 10 && rowIndex != count - 1) {
                        traceBuilder.append(ToolTipManager.formatRow((String)"..."));
                        return traceBuilder.toString();
                    }
                    ++rowIndex;
                }
            }
            return traceBuilder.toString();
        }
        return null;
    }

    static class ResourceManager
    implements DisposeListener {
        public int size = 14;
        private final Image m_image;
        private final Image m_backGroundImage;
        private final Color m_selectedColor;

        public ResourceManager(Composite parent, int red, int green, int blue) {
            ColorProvider p = new ColorProvider(parent.getDisplay(), this.size);
            Color c = new Color((Device)parent.getDisplay(), red, green, blue);
            this.m_image = p.createImage(c, null);
            c.dispose();
            this.m_selectedColor = GraphHelper.SELECTED_COLOR.createSWTColor((Device)parent.getDisplay());
            this.m_backGroundImage = new Image((Device)parent.getDisplay(), 5, this.size);
            GC gc = new GC((Drawable)this.m_backGroundImage);
            gc.setBackground(parent.getDisplay().getSystemColor(29));
            gc.fillRectangle(this.m_backGroundImage.getBounds());
            gc.dispose();
            parent.addDisposeListener((DisposeListener)this);
        }

        public Image getImage() {
            return this.m_image;
        }

        public Color getSelectedColor() {
            return this.m_selectedColor;
        }

        public Image getBackgroundImage() {
            return this.m_backGroundImage;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.m_image != null && !this.m_image.isDisposed()) {
                this.m_image.dispose();
            }
            if (this.m_backGroundImage != null && !this.m_backGroundImage.isDisposed()) {
                this.m_backGroundImage.dispose();
            }
            if (this.m_selectedColor != null && !this.m_selectedColor.isDisposed()) {
                this.m_selectedColor.dispose();
            }
        }
    }
}

