/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;

public final class HistogramItemProvider
extends AbstractFieldTableContentProvider {
    private boolean m_userSelectable;

    public Object[] getColumnObject(Object inputRowElement) {
        HistogramItem histogramItem = (HistogramItem)inputRowElement;
        Object[] result = null;
        if (this.hasUserSelectable()) {
            Object[] values = histogramItem.getValues();
            result = new Object[values.length + 1];
            result[0] = histogramItem.getKey();
            int n = 0;
            while (n < values.length) {
                result[n + 1] = values[n];
                ++n;
            }
            return result;
        }
        result = histogramItem.getValues();
        if (histogramItem.isOther() && result.length > 0) {
            result[0] = Messages.HISTOGRAM_MODEL_OTHER_OVERFLOW_TEXT;
        }
        return result;
    }

    public void setUserSelectable(boolean userSelectableGroupBy) {
        this.m_userSelectable = userSelectableGroupBy;
    }

    private boolean hasUserSelectable() {
        return this.m_userSelectable;
    }

    public Object[] getRowElements(Object inputElement) {
        HistogramModel model = (HistogramModel)((ViewModelBuilder)inputElement).getModel();
        return model != null ? model.getHistogramItems().toArray() : new Object[]{};
    }
}

