/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;

final class HistogramSelectionIterator
implements Iterator<IEvent> {
    private Object firstKey;
    private Set<Object> keys;
    private Iterator<IEvent> eventIterator;
    private IEvent nextEvent;
    private final GathererFactory gatherFactory;
    private IField lastGroupBy;
    private IEventType lastEventType;

    HistogramSelectionIterator(IStructuredSelection selection, GathererFactory gf, IView cloud) {
        if (selection.size() == 1) {
            this.firstKey = ((HistogramItem)selection.getFirstElement()).getKey();
        } else {
            this.keys = new HashSet<Object>();
            for (Object hi : selection.toList()) {
                this.keys.add(((HistogramItem)hi).getKey());
            }
        }
        this.eventIterator = cloud.iterator();
        this.gatherFactory = gf;
        this.skipForwardEvent();
    }

    private void skipForwardEvent() {
        while (this.eventIterator.hasNext()) {
            IEvent event = this.eventIterator.next();
            IField groupBy = null;
            if (event.getEventType() == this.lastEventType) {
                groupBy = this.lastGroupBy;
            } else {
                RetriverHolder mapper = this.gatherFactory.getRetrivers(event.getEventType());
                if (mapper != null) {
                    this.lastEventType = event.getEventType();
                    this.lastGroupBy = groupBy = mapper.getGroupBy();
                }
            }
            if (groupBy == null) continue;
            Object key = groupBy.getValue(event);
            if (!(this.keys != null ? this.keys.contains(key) : this.firstKey.equals(key))) continue;
            this.nextEvent = event;
            return;
        }
        this.nextEvent = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextEvent != null;
    }

    @Override
    public IEvent next() {
        if (this.hasNext()) {
            IEvent event = this.nextEvent;
            this.skipForwardEvent();
            return event;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

