/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.successors;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.histogram.successors.SuccessorTraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceTreeComponent;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SuccessorComponent
extends TraceTreeComponent {
    @Override
    protected ViewModelBuilder createModelBuilder() {
        return new ViewModelBuilder<TraceModel>(this.getServiceLocator(), this.getComponentDescriptor().getName()){

            @Override
            protected SuccessorTraceModel buildModel(IView view, IProgressMonitor monitor) {
                IView flrView = SuccessorComponent.this.getFlightRecording().createView();
                flrView.setRange(view.getRange());
                flrView.setFilter(view.getFilter());
                flrView.setEventTypes(view.getEventTypes());
                flrView.setOrder(view.getOrder());
                List frames = SuccessorComponent.this.createFrameList((Iterable)view);
                IMCFrame r = frames.isEmpty() ? null : (IMCFrame)frames.iterator().next();
                SuccessorTraceModel m = new SuccessorTraceModel(r, this.getServiceLocator(), SuccessorComponent.this.getRepository(), flrView);
                m.rebuild();
                if (m.isMaxedOut()) {
                    this.setLastBuildMessage(Messages.TRACE_COMPONENT_TOO_MAY_TRACES_TO_SHOW_THEM_ALL_TEXT);
                }
                return m;
            }
        };
    }

    @Override
    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
    }

    public void consumeEvents(Iterable<IEvent> events) {
        if (this.getRepository().getRole() == Role.SLAVE) {
            IView oldView = this.getModelBuilder().getView();
            IView newView = this.getFlightRecording().createView();
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
        }
    }

    private List<IMCFrame> createFrameList(Iterable<IEvent> events) {
        IEvent e;
        IMCFrame frame;
        Iterator<IEvent> ite = events.iterator();
        ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
        if (ite.hasNext() && (frame = (IMCFrame)(e = ite.next()).getValue("((stackTrace).frame)")) != null) {
            frames.add(frame);
        }
        return frames;
    }
}

