/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.threadroot;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.histogram.threadroot.ProfileMethodField;
import com.jrockit.mc.flightrecorder.ui.components.histogram.threadroot.ThreadRootModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceTreeComponent;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ThreadRootComponent
extends TraceTreeComponent {
    @Override
    protected ViewModelBuilder createModelBuilder() {
        return new ViewModelBuilder<TraceModel>(this.getServiceLocator(), this.getComponentDescriptor().getName()){

            @Override
            protected ThreadRootModel buildModel(IView view, IProgressMonitor monitor) {
                IView flrView = ThreadRootComponent.this.getFlightRecording().createView();
                flrView.setRange(view.getRange());
                flrView.setFilter(view.getFilter());
                flrView.setEventTypes(view.getEventTypes());
                flrView.setOrder(view.getOrder());
                ThreadRootModel m = new ThreadRootModel(this.getServiceLocator(), ThreadRootComponent.this.getRepository(), flrView);
                m.rebuild();
                if (m.isMaxedOut()) {
                    this.setLastBuildMessage(Messages.TRACE_COMPONENT_TOO_MAY_TRACES_TO_SHOW_THEM_ALL_TEXT);
                }
                return m;
            }
        };
    }

    @Override
    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
    }

    public void consumeEvents(Iterable<IEvent> events) {
        if (this.getRepository().getRole() == Role.SLAVE) {
            IView oldView = this.getModelBuilder().getView();
            IView newView = this.getFlightRecording().createView();
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
        }
    }

    protected Field createMethodField(int index) {
        ProfileMethodField field = new ProfileMethodField(0);
        field.setName(Messages.THREAD_ROOT_COMPONENT_METHOD_LABEL);
        field.setVisible(true);
        field.setMinWidth(300);
        field.setWidthWeight(300);
        field.setModifiable(false);
        field.setSortOrder(true);
        return field;
    }
}

