/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.threadroot;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.internal.fields.AlmostThreadRootFrameField;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNodeTreeBuilder;
import java.util.List;
import java.util.ListIterator;

public class ThreadRootNodeBuilder
extends FrameNodeTreeBuilder {
    private FrameNode other;

    public ThreadRootNodeBuilder(FrameNode topNode, FrameEqualityChecker frameEqualityChecker, GathererFactory gathererFactory) {
        super(topNode, frameEqualityChecker, gathererFactory, IMCAggregatedFrame.AggregationType.SINGLE);
    }

    @Override
    protected void addTrace(HistogramItem traceInformation) {
        IAggregator[] aggregators = traceInformation.getAggregators();
        Object object = traceInformation.getKey();
        if (object instanceof IMCStackTrace) {
            IMCStackTrace s = (IMCStackTrace)object;
            List frames = s.getFrames();
            if (!s.getTruncationState().isTruncated()) {
                this.add(traceInformation, aggregators, this.getTopNode(), frames.listIterator(frames.size()));
            } else {
                if (this.other == null) {
                    this.other = this.createFrameNode(traceInformation, AlmostThreadRootFrameField.UNKNOWN, this.getTopNode().getNormalizer());
                    this.getTopNode().addChild(this.other);
                }
                this.other.addAggregators(aggregators);
                this.add(traceInformation, aggregators, this.other, frames.listIterator(frames.size()));
            }
            traceInformation.setUsed(true);
        }
    }

    private void add(HistogramItem traceInformation, IAggregator[] aggregators, FrameNode frameNode, ListIterator<? extends IMCFrame> iterator) {
        while (iterator.hasPrevious()) {
            IMCFrame frame = iterator.previous();
            frameNode = this.nextFrameNode(traceInformation, frameNode, frame);
            frameNode.addAggregators(aggregators);
        }
    }
}

