/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.multichart.Chart;
import com.jrockit.mc.flightrecorder.ui.components.multichart.XYDataSeries;
import java.util.HashMap;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DefaultXYData;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.TimestampedDataProvider;

final class ChartContentProvider
implements IStructuredContentProvider {
    private final HashMap<Object, Chart> m_keySeriesMap = new HashMap();
    private FLRChartDescriptor m_chartDescriptor;
    private final String m_attribute;

    public ChartContentProvider(FLRChartDescriptor cd) {
        this.m_chartDescriptor = cd;
        this.m_attribute = cd.getGroupBy().getAttribute();
    }

    public void addEvent(IEvent e) {
        Object key = e.getValue(this.m_attribute);
        if (key != null) {
            Chart chart = this.m_keySeriesMap.get(key);
            if (chart == null) {
                chart = this.createChart(key, this.m_chartDescriptor);
                this.m_keySeriesMap.put(key, chart);
            }
            chart.addEvent(e);
            DataSeries[] dataSeriesArray = chart.getDataProvider().getDataSeries();
            int n = dataSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataSeries ds = dataSeriesArray[n2];
                ((XYDataSeries)ds).add((IXYData<Long, Number>)new DefaultXYData((Object)e.getEndTimestamp(), (Object)e.getDuration()));
                ++n2;
            }
        }
    }

    private Chart createChart(Object key, FLRChartDescriptor chartDescriptor) {
        return new Chart(key, this.createDataProvider(chartDescriptor));
    }

    public TimestampedDataProvider createDataProvider(FLRChartDescriptor chartDescriptor) {
        TimestampedDataProvider provider = new TimestampedDataProvider();
        int i = 0;
        while (i < chartDescriptor.getDataSeriesDescriptors().size()) {
            provider.addDataSeries((DataSeries)new XYDataSeries());
            ++i;
        }
        return provider;
    }

    public Chart getChart(Object key) {
        return this.m_keySeriesMap.get(key);
    }

    public void dispose() {
        this.m_keySeriesMap.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.m_chartDescriptor = null;
        if (newInput instanceof FLRChartDescriptor) {
            this.m_chartDescriptor = (FLRChartDescriptor)((Object)newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.m_keySeriesMap.keySet().toArray();
    }
}

