/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.actions;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.OperativeSetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import java.util.Arrays;
import java.util.Set;

public final class AddMatchingRelationalKeyAction
extends OperativeSetAction {
    private String relKey;
    private Set<Object> acceptedValues;
    private Object acceptedValue;

    public AddMatchingRelationalKeyAction(OperativeSetService oss, String relKey, Object acceptedValue, String text) {
        super(oss);
        this.setText(text);
        this.relKey = relKey;
        this.acceptedValue = acceptedValue;
    }

    public AddMatchingRelationalKeyAction(OperativeSetService oss, String relKey, Set<Object> acceptedValues, String text) {
        super(oss);
        this.setText(text);
        this.relKey = relKey;
        this.acceptedValues = acceptedValues;
    }

    @Override
    public void process() {
        block0: for (IEventType t : this.getRecording().getEventTypes()) {
            for (IField f : t.getFields()) {
                if (!this.relKey.equals(f.getRelationalKey())) continue;
                this.addMatchingEventsForType(t, f);
                continue block0;
            }
        }
    }

    private void addMatchingEventsForType(IEventType type, IField f) {
        IView view = this.getRecording().createView();
        view.setRange(this.getRange());
        view.setEventTypes(Arrays.asList(type));
        for (IEvent event : view) {
            Object value = f.getValue(event);
            if ((this.acceptedValue == null || !this.acceptedValue.equals(value)) && (this.acceptedValues == null || !this.acceptedValues.contains(value))) continue;
            EventToolkit.setPartOfOperativeSet(event, true);
        }
    }
}

