/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.components.ui.SetData;
import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageModel;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.NavigatorConfigurer;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ISynchronizable;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.components.range.NavigatorListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ProgressComponent;
import com.jrockit.mc.flightrecorder.ui.components.range.RangeController;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.legend.LegendViewer;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class Navigator
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
IOperativeSetAware,
ISynchronizable,
IPropertyChangeListener,
ITypeVisibilityChange {
    private static final int MINIMUM_DURATION = 1000;
    private static final double ZOOM_FACTOR = 2.0;
    private static final double TRANSLATION_FACTOR = 0.3;
    private final DateFormat m_timeFormatter;
    private RangeController m_rangeController;
    private final ProgressComponent m_panel = new ProgressComponent();
    private Button m_translateBackButton;
    private Button m_translateForwardButton;
    private Label m_leftLabel;
    private Label m_rightLabel;
    private Button m_zoomOutButton;
    private Button m_zoomInButton;
    private Button m_selectAllButton;
    private JComponentNavigator m_navigator;
    private Button m_syncButton;
    private SelectionListener m_synchSelectionListener;
    private Label m_durationLabel;
    private LegendViewer m_legendViewer;
    private Composite m_topRow;
    private Composite m_controlPanel;
    private Composite m_container;
    private FLRChartDescriptor m_chartDescriptor;
    private boolean autoConfigure;
    private IServiceLocator m_serviceLocator;
    private boolean m_changeEnabled = false;

    public Navigator() {
        this.m_timeFormatter = DateFormat.getDateTimeInstance(3, 2);
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            this.autoConfigure = this.getComponentDescriptor().getTypeIdentifier().equals("mc.flr.AutoRangeNavigator");
            if (this.autoConfigure) {
                this.m_serviceLocator = serviceLocator;
                this.m_chartDescriptor = NavigatorConfigurer.createChartDescriptor();
            } else {
                ViewModelBuilder<ChartImageModel> builder = this.createModelBuilder();
                builder.setEventView(this.createView());
                builder.setOperativeSetEnabled(false);
                serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            }
            serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
            this.m_rangeController = new RangeController(this.getComponents(), this, (ITimeRange)new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp()));
            return true;
        }
        return false;
    }

    public boolean dispose(IServiceLocator locator) {
        UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        return super.dispose(locator);
    }

    private IView createView() {
        return this.getFlightRecording().createView();
    }

    public boolean supportsToolbar() {
        return false;
    }

    private ViewModelBuilder<ChartImageModel> createModelBuilder() {
        return new ChartImageBuilder(this.getServiceLocator(), this.getChartDescriptor(this.getComponentDescriptor()), this.getComponentDescriptor().getName());
    }

    private FLRChartDescriptor getChartDescriptor() {
        return this.getChartDescriptor(this.getComponentDescriptor());
    }

    private FLRChartDescriptor getChartDescriptor(ComponentDescriptor componentDescriptor) {
        if (this.autoConfigure) {
            return this.m_chartDescriptor;
        }
        return (FLRChartDescriptor)((Object)componentDescriptor.getComponentSettings().getChildObject("chartDescriptor", FLRChartDescriptor.class));
    }

    public Composite createPart(Composite parent) {
        this.m_container = this.getFormToolkit().createComposite(parent);
        this.m_container.setLayout((Layout)this.createClientLayout());
        this.m_topRow = this.createTopRow();
        this.m_topRow.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_navigator = this.createNavigator();
        this.m_navigator.setLayoutData(new GridData(4, 4, true, true));
        this.m_controlPanel = this.createControlPanel();
        this.m_controlPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setInitialButtonDecorations();
        if (!this.autoConfigure) {
            this.hookModelView();
        }
        return this.m_container;
    }

    private Button createSynchronizationButton(Composite client) {
        final Button button = this.getFormToolkit().createButton(client, Messages.NAVIGATOR_SYNCHRONIZE_BUTTON_TEXT, 32);
        button.setSelection(RangeController.getUseSynchronization());
        this.m_synchSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.m_rangeController.setUseSynchronization(button.getSelection());
            }
        };
        button.addSelectionListener(this.m_synchSelectionListener);
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"synchronize.selection");
        return button;
    }

    private GridLayout createClientLayout() {
        GridLayout l = new GridLayout();
        l.verticalSpacing = 2;
        l.marginHeight = 0;
        l.marginWidth = 0;
        l.numColumns = 1;
        return l;
    }

    private JComponentNavigator createNavigator() {
        final JComponentNavigator navigator = new JComponentNavigator(this.m_container, (FormToolkit)this.getServiceLocator().getService(FormToolkit.class), this.m_panel);
        navigator.setToolTipText(this.getComponentDescriptor().getDescription());
        navigator.setNavigatorRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp());
        navigator.addSelectionListener(new NavigatorListener(){

            @Override
            public void onNavigatorChange(Object source, double minX, double maxX) {
                long start = Math.round(minX);
                long end = Math.round(maxX);
                if (minX == navigator.getViewportMin()) {
                    start = Navigator.this.getStartService().getStartTimestamp();
                }
                if (maxX == navigator.getViewportMax()) {
                    end = Navigator.this.getStartService().getEndTimestamp();
                }
                Navigator.this.update(start, end, true);
            }
        });
        this.hookResizeListener(navigator);
        return navigator;
    }

    private void hookTimeAccessibility(final Button button) {
        button.getAccessible().addAccessibleListener(new AccessibleListener(){

            public void getName(AccessibleEvent e) {
                e.result = this.getAccessibleString();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
            }

            public void getHelp(AccessibleEvent e) {
                e.result = this.getAccessibleString();
            }

            public void getDescription(AccessibleEvent e) {
                e.result = this.getAccessibleString();
            }

            private String getAccessibleString() {
                return NLS.bind((String)"{0}. {1}", (Object)button.getToolTipText(), (Object)Navigator.this.getRangeSettingsAsAccesibleString());
            }
        });
    }

    private Object getRangeSettingsAsAccesibleString() {
        return NLS.bind((String)Messages.NAVIGATOR_RANGE_SETTING_PROPERTIES, (Object[])new String[]{this.m_durationLabel.getText(), this.m_leftLabel.getText(), this.m_rightLabel.getText()});
    }

    private void hookResizeListener(JComponentNavigator navigator) {
        navigator.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (Navigator.this.getModelBuilder() != null) {
                    int width = ((JComponentNavigator)((Object)e.getSource())).getClientArea().width;
                    int height = ((JComponentNavigator)((Object)e.getSource())).getClientArea().height;
                    Navigator.this.getModelBuilder().setSize(width, height);
                    Navigator.this.markDirty();
                }
            }
        });
    }

    private void hookModelView() {
        this.getModelBuilder().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (o instanceof ChartImageBuilder) {
                    Navigator.this.refreshInUIThread((ChartImageModel)((ChartImageBuilder)o).getModel());
                }
            }
        });
    }

    protected final void refreshInUIThread(final ChartImageModel imageModel) {
        DisplayToolkit.safeAsyncExec((Widget)this.m_navigator, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Navigator.this.m_navigator.isDisposed()) {
                    Navigator.this.m_panel.setNewImage(imageModel.getImage());
                    Navigator.this.m_panel.setInProgress(false);
                    Navigator.this.m_navigator.invalidateNavigator(true);
                    Navigator.this.m_navigator.redraw();
                }
            }
        });
    }

    private LegendViewer createLegendViewer(Composite parent, FormToolkit formToolkit) {
        LegendViewer viewer = new LegendViewer(parent, formToolkit);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider((ChartDescriptor)this.getChartDescriptor(), parent.getDisplay(), 8));
        return viewer;
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    private Composite createTopRow() {
        Composite container = this.getFormToolkit().createComposite(this.m_container, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        GridData gd0 = new GridData(4, 128, true, true);
        this.m_legendViewer = this.createLegendViewer(container, this.getFormToolkit());
        this.m_legendViewer.getControl().setLayoutData((Object)gd0);
        GridData gd1 = new GridData(0x1000000, 128, true, true);
        this.m_durationLabel = this.createTimeLabel(this.getFormToolkit(), container, 0x1000000);
        this.m_durationLabel.setLayoutData((Object)gd1);
        SetData.set((Widget)this.m_durationLabel, (ComponentDescriptor)this.getComponentDescriptor(), (String)"duration");
        GridData gd2 = new GridData(131072, 128, true, true);
        this.m_syncButton = this.createSynchronizationButton(container);
        this.m_syncButton.setLayoutData((Object)gd2);
        return container;
    }

    private Composite createControlPanel() {
        FormToolkit toolkit = this.getFormToolkit();
        Composite container = toolkit.createComposite(this.m_container, 0);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        this.m_leftLabel = this.createTimeLabel(toolkit, container, 16384);
        GridData leftLabelLayoutData = new GridData(4, 4, true, true);
        leftLabelLayoutData.widthHint = 200;
        this.m_leftLabel.setLayoutData((Object)leftLabelLayoutData);
        this.m_leftLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SetData.set((Widget)this.m_leftLabel, (ComponentDescriptor)this.getComponentDescriptor(), (String)"start.time");
        this.m_translateBackButton = this.createTranslateBackward(container);
        this.m_translateBackButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_zoomOutButton = this.createZoomOut(container);
        this.m_zoomOutButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_selectAllButton = this.createSelectAll(container);
        this.m_selectAllButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_zoomInButton = this.createZoomIn(container);
        this.m_zoomInButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_translateForwardButton = this.createTranslateForward(container);
        this.m_translateForwardButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_rightLabel = this.createTimeLabel(toolkit, container, 131072);
        GridData rightLabelLayoutData = new GridData(4, 4, true, true);
        rightLabelLayoutData.widthHint = 200;
        this.m_rightLabel.setLayoutData((Object)rightLabelLayoutData);
        this.m_rightLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SetData.set((Widget)this.m_rightLabel, (ComponentDescriptor)this.getComponentDescriptor(), (String)"end.time");
        return container;
    }

    private Button createTranslateForward(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.translate(0.3);
                Navigator.this.updateSelectedArea();
            }
        });
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"move.forward");
        this.hookTimeAccessibility(button);
        return button;
    }

    private Button createTranslateBackward(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.translate(-0.3);
                Navigator.this.updateSelectedArea();
            }
        });
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"move.backward");
        this.hookTimeAccessibility(button);
        return button;
    }

    private void translate(double factor) {
        ITimeRange oldRange = this.m_rangeController.getRange();
        long duration = Math.max(oldRange.getDuration(), 1000L);
        long translation = Math.round(factor * (double)duration);
        this.update(oldRange.getStartTimestamp() + translation, oldRange.getEndTimestamp() + translation, true);
    }

    private void enableButton(Button button, boolean enabled) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private Button createZoomIn(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"zoom.in");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.zoom(2.0);
                Navigator.this.updateSelectedArea();
            }
        });
        this.hookTimeAccessibility(button);
        return button;
    }

    private void updateSelectedArea() {
        ITimeRange r = this.m_rangeController.getRange();
        this.m_navigator.setSelectedAreaInWorldCoordinates(r.getStartTimestamp(), r.getEndTimestamp());
        this.m_navigator.redraw();
    }

    private void zoom(double factor) {
        ITimeRange oldRange = this.m_rangeController.getRange();
        long oldDuration = oldRange.getDuration();
        long newDuration = Math.max(Math.round((double)oldDuration / factor), 1000L);
        long padding = (oldDuration - newDuration) / 2L;
        this.update(oldRange.getStartTimestamp() + padding, oldRange.getEndTimestamp() - padding, true);
    }

    private Button createZoomOut(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"zoom.out");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.zoom(0.5);
                Navigator.this.updateSelectedArea();
            }
        });
        this.hookTimeAccessibility(button);
        return button;
    }

    private Button createSelectAll(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_SELECT_ALL_TEXT);
        SetData.set((Widget)button, (ComponentDescriptor)this.getComponentDescriptor(), (String)"select.all");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.m_navigator.expandFullyOrRestore();
                Navigator.this.update(Navigator.this.getStartService().getStartTimestamp(), Navigator.this.getStartService().getEndTimestamp(), true);
            }
        });
        this.hookTimeAccessibility(button);
        return button;
    }

    private Label createTimeLabel(FormToolkit toolkit, Composite parent, int alignMent) {
        return toolkit.createLabel(parent, "-- : -- : --", 0x48 | alignMent);
    }

    @Override
    public void onChange(long startTime, long endTime) {
        long duration = this.getStartService().getEndTimestamp() - this.getStartService().getStartTimestamp();
        if (duration > 0L) {
            double startN = (double)(startTime - this.getStartService().getStartTimestamp()) / (double)duration;
            double endN = (double)(endTime - this.getStartService().getStartTimestamp()) / (double)duration;
            this.m_navigator.setSelectedArea(startN, endN);
            this.update(startTime, endTime, false);
            this.m_navigator.redraw();
        }
    }

    private void updateDurationText(long startL, long endL) {
        long nanos = endL - startL;
        String duration = TimeRangeToolkit.convertNanosToApproximateString((long)nanos, (int)2);
        String text = startL == this.getStartService().getStartTimestamp() && endL == this.getStartService().getEndTimestamp() ? MessageFormat.format(Messages.NAVIGATOR_INTERVAL_TEXT_ALL, duration) : MessageFormat.format(Messages.NAVIGATOR_INTERVAL_TEXT_SELECTED, duration);
        this.m_durationLabel.setText(text);
    }

    public void update(long startL, long endL, boolean broadcast) {
        startL = Math.max(this.getStartService().getStartTimestamp(), startL);
        if (startL > (endL = Math.min(this.getStartService().getEndTimestamp(), endL))) {
            startL = endL;
        }
        this.enableButton(this.m_translateBackButton, startL > this.getStartService().getStartTimestamp());
        this.enableButton(this.m_translateForwardButton, endL < this.getStartService().getEndTimestamp());
        this.enableButton(this.m_zoomOutButton, startL > this.getStartService().getStartTimestamp() || endL < this.getStartService().getEndTimestamp());
        this.enableButton(this.m_zoomInButton, (double)(endL - startL) >= 2000.0);
        this.enableButton(this.m_selectAllButton, startL > this.getStartService().getStartTimestamp() || endL < this.getStartService().getEndTimestamp());
        long durationNanos = endL - startL;
        this.setText(this.m_leftLabel, this.formatDateTimeNanos(startL, durationNanos));
        this.setText(this.m_rightLabel, this.formatDateTimeNanos(endL, durationNanos));
        this.m_rangeController.setRange((ITimeRange)new TimeRange(startL, endL), broadcast);
        this.updateDurationText(startL, endL);
        this.m_container.layout(true, true);
    }

    private String formatDateTimeNanos(long nanos, long duration) {
        int NANOS_IN_SECOND = 1000000000;
        String dateTime = this.m_timeFormatter.format(nanos / 1000000L);
        if (duration >= 1000000000L) {
            return dateTime;
        }
        long partOfSecond = nanos % 1000000000L;
        int numberOfComponents = 3 - (int)(Math.log10(Math.max(1L, duration)) - 1.0) / 3;
        return String.valueOf(dateTime) + " - " + TimeRangeToolkit.convertNanosToApproximateString((long)partOfSecond, (int)numberOfComponents);
    }

    private void updateSynchbutton() {
        if (this.m_syncButton != null && !this.m_syncButton.isDisposed()) {
            this.m_syncButton.removeSelectionListener(this.m_synchSelectionListener);
            this.m_syncButton.setSelection(RangeController.getUseSynchronization());
            this.m_syncButton.addSelectionListener(this.m_synchSelectionListener);
        }
    }

    private void setText(Label text, String value) {
        if (text != null && !text.isDisposed()) {
            text.setText(value);
        }
    }

    public void hide() {
    }

    protected OperativeSetService getOperativeSetService() {
        return (OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class);
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    private boolean listContains(List<EventTypeDescriptor> list, EventTypeDescriptor etd) {
        for (EventTypeDescriptor element : list) {
            if (!element.getIdentifier().equals(etd.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public void initializeUI() {
        super.initializeUI();
        if (this.autoConfigure) {
            EventTypeDescriptorRepository repo = new EventTypeDescriptorRepository();
            List<EventTypeDescriptor> descriptors = repo.getDescriptors();
            for (ITypeVisibilitySupport v : this.getComponents().getAllComponents(ITypeVisibilitySupport.class)) {
                EventTypeDescriptorRepository etd = v.getEventTypeDescriptorRepository();
                for (EventTypeDescriptor componentRepo : etd.getDescriptors()) {
                    if (this.listContains(descriptors, componentRepo)) continue;
                    descriptors.add(componentRepo);
                }
                if (!etd.getUserFilterConstrained()) continue;
                this.m_changeEnabled = true;
                repo.setUserFilterConstrained(true);
            }
            List dataSeries = this.m_chartDescriptor.getLeftYAxis().getDataSeries();
            dataSeries.add(NavigatorConfigurer.createDataSeriesDescriptor(repo, false));
            dataSeries.add(NavigatorConfigurer.createDataSeriesDescriptor(repo, true));
            ViewModelBuilder<ChartImageModel> builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            this.m_serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            this.hookModelView();
            this.getModelBuilder().setSize(this.m_navigator.getClientArea().width, this.m_navigator.getClientArea().height);
        }
        this.m_legendViewer.setInput((Object)this.getChartDescriptor().getLegendDescriptors());
        TimeRange fullRange = new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp());
        this.getModelBuilder().setRange((ITimeRange)fullRange);
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    public void refresh() {
        if (!this.m_navigator.isDisposed()) {
            if (!this.getModelBuilder().rebuildAWT()) {
                if (!this.m_panel.isInProgress()) {
                    this.m_panel.setInProgress(true);
                    this.scheduleProgress();
                }
                this.m_navigator.invalidateNavigator(true);
                this.m_navigator.redraw();
            }
            this.update(this.m_rangeController.getRange().getStartTimestamp(), this.m_rangeController.getRange().getEndTimestamp(), false);
        }
    }

    private void scheduleProgress() {
        DisplayToolkit.safeTimerExec((Widget)this.m_navigator, (int)100, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (Navigator.this.m_panel.isInProgress()) {
                    Navigator.this.m_navigator.invalidateNavigator(true);
                    Navigator.this.m_navigator.redraw();
                    Navigator.this.scheduleProgress();
                }
            }
        });
    }

    private ChartImageBuilder getModelBuilder() {
        return (ChartImageBuilder)this.getServiceLocator().getService(ViewModelBuilder.class.getName());
    }

    @Override
    public void operativeSetChange() {
        this.markDirty();
    }

    @Override
    public void synchronizationChange() {
        this.updateSynchbutton();
        this.updateSelectedRange();
    }

    private void updateSelectedRange() {
        ITimeRange r = this.m_rangeController.getRange();
        this.update(r.getStartTimestamp(), r.getEndTimestamp(), false);
    }

    private void setInitialButtonDecorations() {
        boolean buttonAsText = UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.buttonsAsText");
        this.setButtonDecorations(buttonAsText);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.m_controlPanel.isDisposed()) {
            return;
        }
        if (event.getProperty().equals("accessibility.buttonsAsText")) {
            boolean buttonAsText = (Boolean)event.getNewValue();
            this.setButtonDecorations(buttonAsText);
        }
    }

    private void setButtonDecorations(boolean buttonAsText) {
        if (buttonAsText) {
            this.setButtonTexts();
        } else {
            this.setButtonPictures();
        }
        this.m_controlPanel.layout();
    }

    private void setButtonTexts() {
        this.m_translateBackButton.setImage(null);
        this.m_translateForwardButton.setImage(null);
        this.m_zoomOutButton.setImage(null);
        this.m_zoomInButton.setImage(null);
        this.m_selectAllButton.setImage(null);
        this.m_translateBackButton.setText(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        this.m_translateForwardButton.setText(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        this.m_zoomOutButton.setText(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        this.m_zoomInButton.setText(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        this.m_selectAllButton.setText(Messages.NAVIGATOR_SELECT_ALL_TEXT);
    }

    private void setButtonPictures() {
        this.m_translateBackButton.setText("");
        this.m_translateForwardButton.setText("");
        this.m_zoomOutButton.setText("");
        this.m_zoomInButton.setText("");
        this.m_selectAllButton.setText("");
        this.m_translateBackButton.setImage(UIPlugin.getDefault().getImage("backward_nav.gif"));
        this.m_translateForwardButton.setImage(UIPlugin.getDefault().getImage("forward_nav.gif"));
        this.m_zoomOutButton.setImage(UIPlugin.getDefault().getImage("zoom-out-16.png"));
        this.m_zoomInButton.setImage(UIPlugin.getDefault().getImage("zoom-in-16.png"));
        this.m_selectAllButton.setImage(UIPlugin.getDefault().getImage("select-all-16.png"));
    }

    @Override
    public boolean isTypeChangeEnabled() {
        return this.m_changeEnabled;
    }

    @Override
    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
        this.markDirty();
    }
}

