/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.stack;

import com.jrockit.mc.components.ui.base.AbstractUIContainer;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.adaptive.AdaptiveModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.adaptive.AdaptiveModelItem;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class StackComponent
extends AbstractUIContainer
implements IEventConsumer {
    private AdaptiveModelBuilder builder;
    private List<Control> controls = new ArrayList<Control>();
    private Composite container;
    private StackLayout layout;

    public final Control createPart(Composite parent) {
        this.layout = new StackLayout();
        this.container = this.getFormToolkit().createComposite(parent);
        this.container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        this.container.setLayout((Layout)this.layout);
        GUIFactory factory = GUIFactory.createChildFactory((IServiceLocator)this.getServiceLocator());
        for (LayoutItem layoutItem : this.getLayoutItem().getChildren()) {
            ComponentHolder ch = factory.createDisposableComponent(layoutItem, this.container);
            if (ch.control == null) continue;
            ch.control.setLayoutData(LayoutToolkit.createSimpleLayoutData((LayoutItem)layoutItem));
            factory.addComponentToScope(ch.component);
            this.controls.add(ch.control);
        }
        this.builder = new AdaptiveModelBuilder(this.getServiceLocator(), this.getComponentDescriptor());
        return this.container;
    }

    public void initializeUI() {
        this.builder.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                StackComponent.this.showInUIThread();
            }
        });
    }

    protected void refresh() {
        this.builder.scheduleRebuild();
    }

    private void showInUIThread() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int index = 0;
                for (Boolean visible : (List)StackComponent.this.builder.getModel()) {
                    if (visible.booleanValue()) {
                        ((StackComponent)StackComponent.this).layout.topControl = (Control)StackComponent.this.controls.get(index);
                        StackComponent.this.container.layout(true, true);
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events, Role Source) {
        if (Source.equals((Object)Role.MASTER)) {
            LinkedList<AdaptiveModelItem> items = new LinkedList<AdaptiveModelItem>();
            for (ITypeVisibilitySupport v : this.getComponents().getAllComponents(ITypeVisibilitySupport.class)) {
                EventTypeDescriptorRepository repo = v.getEventTypeDescriptorRepository();
                EventTypeAcceptor acceptor = new EventTypeAcceptor(this.getServiceLocator(), repo);
                AdaptiveModelItem smi = new AdaptiveModelItem(acceptor.getAcceptedSet());
                items.add(smi);
            }
            this.builder.setModelItems(items);
            this.builder.setEventView(new SimpleView(events));
            this.markDirty();
        }
    }
}

