/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.table;

import com.jrockit.mc.components.ui.SetData;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.ImageDescriptorImageProvider;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.ui.fields.CommonLabelProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableViewerComponent
extends ColumnViewerComponent
implements INavigatorSelectionChangeListener,
ITypeVisibilityChange,
IEventConsumer,
ITypeVisibilitySupport {
    public boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    @Override
    protected abstract ViewModelBuilder createModelBuilder();

    protected abstract IContentProvider createContentProvider(ColumnDescriptorRepository var1);

    protected StructuredViewer createViewer(Composite parent) {
        Table table = this.getFormToolkit().createTable(parent, 268501762);
        SetData.set((Widget)table, (ComponentDescriptor)this.getComponentDescriptor(), (String)"table");
        FieldTableViewer viewer = new FieldTableViewer(table, this.getFields());
        viewer.setContentProvider(this.createContentProvider(this.getRepository()));
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(parent.getDisplay()));
        this.hookSelectionListener(viewer);
        this.hookModelView((ContentViewer)viewer, this.getModelBuilder());
        viewer.setInput((Object)this.getModelBuilder());
        return viewer;
    }

    protected FieldLabelProvider createLabelProvider(Display display) {
        if (this.getRepository().hasImage()) {
            return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new ImageDescriptorImageProvider(display, this.getRepository().getImageDescriptor()));
        }
        return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new CommonLabelProvider());
    }

    protected IStatus getModelStatus(Object model) {
        String message = this.getModelBuilder().getLastBuildMessage();
        if (message == null) {
            return this.createOKStatus();
        }
        return new Status(2, "com.jrockit.mc.flightrecorder.ui", message);
    }

    protected void refreshViewer(ContentViewer viewer) {
        super.refreshViewer(viewer);
        this.pushSelection((IStructuredSelection)this.getViewer().getSelection());
    }

    @Override
    protected final void pushSelection(IStructuredSelection selection) {
        if (this.getRepository().getRole().getListener() != null) {
            Iterable<IEvent> sif = this.createSelectionIterator(selection);
            for (IEventConsumer ec : this.getComponents().getCompatiblesWithChildren(IEventConsumer.class)) {
                ec.consumeEvents(sif, this.getRepository().getRole());
            }
        }
    }

    protected abstract Iterable<IEvent> createSelectionIterator(IStructuredSelection var1);

    protected void hookSelectionListener(FieldTableViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OperativeSetService oss = (OperativeSetService)AbstractTableViewerComponent.this.getServiceLocator().getService(OperativeSetService.class);
                oss.setSelectedRange(AbstractTableViewerComponent.this.getModelBuilder().getView().getRange());
                oss.setEventSelection((IStructuredSelection)event.getSelection());
                AbstractTableViewerComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getRepository().getEventTypeDescriptorRepository();
    }
}

