/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.preferences;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.LinkedList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench m_workbench;
    public static final String P_OPEN_CONTROL_PANEL_ON_RECORDING_START = "flightRecorder.openControlPanelOnRecordingStart";
    public static final String P_CLOSE_CONTROL_PANEL_ON_RECORDING_END = "flightRecorder.closeControlPanelOnRecordingEnd";
    public static final String P_REMOVE_FINISHED_RECORDING = "flightRecorder.removeFinishedRecording";
    private LinkedList<CheckBox> checkBoxes = new LinkedList();

    public GeneralPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_GENERAL_SETTINGS_TEXT);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Button button = this.createClearButton(container);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        Button removeRecordingsCheckbox = this.createRemoveRecordingsCheckBox(container);
        removeRecordingsCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        return container;
    }

    private Button createClearButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.PREFERENCES_CLEAR_USER_SETTINGS_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.ensureAllEditorsClosed()) {
                    GeneralPage.this.showConfirmUserSettingReset();
                }
            }
        });
        return button;
    }

    private boolean ensureAllEditorsClosed() {
        IEditorReference[] iEditorReferenceArray = this.m_workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if ("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor".equals(ref.getId())) {
                this.showMustCloseEditor();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void showMustCloseEditor() {
        MessageBox messageBox = new MessageBox(this.getShell(), 2);
        messageBox.setMessage(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TITLE);
        messageBox.open();
    }

    private void showConfirmUserSettingReset() {
        MessageBox messageBox = new MessageBox(this.getShell(), 200);
        messageBox.setMessage(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TITLE);
        if (messageBox.open() == 64) {
            ComponentsPlugin.getDefault().getUserInterfaceRepository().clearUserSettings("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor");
        }
    }

    private Button createRemoveRecordingsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_REMOVE_FINISHED_RECORDING_TEXT, P_REMOVE_FINISHED_RECORDING);
    }

    protected void performDefaults() {
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.setToDefault();
        }
        super.performDefaults();
    }

    private Button createCheckBox(Composite parent, String text, final String name) {
        final Button checkBox = new Button(parent, 32);
        checkBox.setSelection(this.getPreferenceStore().getBoolean(name));
        checkBox.setText(text);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.getPreferenceStore().setValue(name, checkBox.getSelection());
            }
        });
        this.checkBoxes.add(new CheckBox(checkBox, name));
        return checkBox;
    }

    public void init(IWorkbench workbench) {
        this.m_workbench = workbench;
    }

    private class CheckBox {
        private Button m_button;
        private String m_preference;

        public CheckBox(Button button, String preference) {
            this.m_button = button;
            this.m_preference = preference;
        }

        public void setToDefault() {
            GeneralPage.this.getPreferenceStore().setToDefault(this.m_preference);
            this.m_button.setSelection(GeneralPage.this.getPreferenceStore().getBoolean(this.m_preference));
        }
    }
}

