/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeComponentFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class ComponentPage
extends Page {
    private final Object m_component;
    private Control m_control;
    private PageBook m_book;
    private Control m_unfilterableControl;

    ComponentPage(IServiceLocator locator) {
        this.m_component = TypeComponentFactory.createTypeComponent(locator);
    }

    public void createControl(Composite parent) {
        this.m_book = new PageBook(parent, 0);
        this.m_control = this.createComponentControl((Composite)this.m_book);
        this.m_unfilterableControl = this.createUnFilterableControl((Composite)this.m_book);
        this.m_book.showPage(this.m_control);
    }

    private Control createComponentControl(Composite parent) {
        if (this.m_component instanceof ICreatePart) {
            ICreatePart createPart = (ICreatePart)this.m_component;
            return createPart.createPart(parent);
        }
        return new Composite(parent, 0);
    }

    Control createUnFilterableControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        Label label = new Label(container, 64);
        label.setText(Messages.TYPE_COMPONENTN_EMPTY_VIEW_TEXT);
        label.setLayoutData((Object)gd);
        return container;
    }

    public Control getControl() {
        return this.m_book;
    }

    public void setFocus() {
        if (this.hasValidBook()) {
            this.m_book.setFocus();
        }
    }

    private boolean hasValidBook() {
        return this.m_book != null && !this.m_book.isDisposed();
    }

    public void show() {
        if (this.hasValidBook()) {
            this.m_book.showPage(this.m_control);
            if (this.m_component instanceof IShowable) {
                ((IShowable)this.m_component).show();
            }
        }
    }

    public void hide() {
        if (this.hasValidBook()) {
            this.m_book.showPage(this.m_unfilterableControl);
            if (this.m_component instanceof IShowable) {
                ((IShowable)this.m_component).hide();
            }
        }
    }
}

